/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ncpeh.api.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Objects;
import lombok.NonNull;

@Schema(enumAsRef=true, description="EuCountryCode benennt ein Datenprofil in Form eines zweistelligen EU-Landescodes. \u00dcber das Datenprofil werden die NCPeH-Zertifikate und die homeCommunityId referenziert, die der NCPeH-Simulator in einem auszuf\u00fchrenden Request nutzen soll.")
public enum EuCountryCode {
    BELGIUM("BE"),
    BULGARIA("BG"),
    CZECH("CZ"),
    DENMARK("DK"),
    GERMANY("DE"),
    ESTONIA("EE"),
    IRELAND("IE"),
    GREECE("EL"),
    SPAIN("ES"),
    FRANCE("FR"),
    CROATIA("HR"),
    ITALY("IT"),
    CYPRESS("CY"),
    LATVIA("LV"),
    LITHUANIA("LT"),
    LUXEMBOURG("LU"),
    HUNGARY("HU"),
    MALTA("MT"),
    NETHERLANDS("NL"),
    AUSTRIA("AT"),
    POLAND("PL"),
    PORTUGAL("PT"),
    ROMANIA("RO"),
    SLOVENIA("SI"),
    SLOVAKIA("SK"),
    FINLAND("FI"),
    SWEDEN("SE");

    private final String countryCode;

    private EuCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @JsonValue
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonCreator
    public static EuCountryCode fromValue(@NonNull String countryCode) {
        Objects.requireNonNull(countryCode, "countryCode is marked non-null but is null");
        return Arrays.stream(EuCountryCode.values()).filter(value -> countryCode.equalsIgnoreCase(value.getCountryCode())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No country code %s known for any EU country", countryCode)));
    }
}

