/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ncpeh.api;

import de.gematik.ncpeh.api.request.FindDocumentsRequest;
import de.gematik.ncpeh.api.request.IdentifyPatientRequest;
import de.gematik.ncpeh.api.request.RetrieveDocumentRequest;
import de.gematik.ncpeh.api.response.ErrorInformation;
import de.gematik.ncpeh.api.response.SimulatorCommunicationData;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="triggerInterface")
public interface NcpehSimulatorApi {
    @POST
    @Path(value="identifyPatient")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Aufruf des Anwendungsfalls \"NCPeH.UC_1 - Versicherten im Behandlungsland identifizieren.\" Abholung von Daten zur Identifikation des Patienten", requestBody=@RequestBody(required=true, description="\u00dcbergibt die Daten, die der NCPeH Simulator braucht, um den XCPD-Request an den NCPeH-Fachdienst f\u00fcr die Patientenidentifikation erzeugen zu k\u00f6nnen.", content={@Content(mediaType="application/json", schema=@Schema(implementation=IdentifyPatientRequest.class))}), responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=SimulatorCommunicationData.class))}, description="Es fand eine Kommunikation zwischen NCPeH Simulator und NCPeH Fachdienst statt. Der Request des Simulators an den NCPeH-Fachdienst und die Response werden zur\u00fcckgegeben."), @ApiResponse(content={@Content(schema=@Schema(implementation=ErrorInformation.class))}, description="Ein Fehler ist im NCPeH Simulator aufgetreten.")})
    public Response identifyPatient(IdentifyPatientRequest var1);

    @POST
    @Path(value="findDocuments")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Aufruf des Anwendungsfalls \"NCPeH.UC_2 - Verf\u00fcgbare Versichertendatens\u00e4tze des ePKA MIO auflisten\". Hole alle Metadaten zu Dokumenten die entsprechend der \u00fcbergebenen Filterkriterien selektiert wurden.", requestBody=@RequestBody(required=true, description="\u00dcbergibt die Daten, die der NCPeH Simulator braucht, um den AdhocQueryRequest an den NCPeH-Fachdienst f\u00fcr die Suche nach Patientendokumenten zu erzeugen (z.B. Filterkriterien).", content={@Content(mediaType="application/json", schema=@Schema(implementation=FindDocumentsRequest.class))}), responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=SimulatorCommunicationData.class))}, description="Es fand eine Kommunikation zwischen NCPeH Simulator und NCPeH Fachdienst statt. Der Request des Simulators an den NCPeH-Fachdienst und die Response werden zur\u00fcckgegeben."), @ApiResponse(content={@Content(schema=@Schema(implementation=ErrorInformation.class))}, description="Ein Fehler ist im NCPeH Simulator aufgetreten.")})
    public Response findDocuments(FindDocumentsRequest var1);

    @POST
    @Path(value="retrieveDocument")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Aufruf der Anwendungsf\u00e4lle \"NCPeH.UC_3 - Versichertendatensatz abrufen\" bzw. \"NCPeH.UC_4 - Versichertendatensatz als PDF abrufen\". Rufe ein Dokument im eHDSI Pivot-Format ab - als CDA Level 3 (XML) oder als CDA Level 1 (PDF)", requestBody=@RequestBody(required=true, description="\u00dcbergibt die Daten, die der NCPeH Simulator braucht, um den retrieveDocumentSetRequest an den NCPeH-Fachdienst f\u00fcr das Abholen eines Dokumentes zu erzeugen.", content={@Content(mediaType="application/json", schema=@Schema(implementation=RetrieveDocumentRequest.class))}), responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=SimulatorCommunicationData.class))}, description="Es fand eine Kommunikation zwischen NCPeH Simulator und NCPeH-Fachdienst statt. Der Request des Simulators an den NCPeH-Fachdienst und die Response werden zur\u00fcckgegeben."), @ApiResponse(content={@Content(schema=@Schema(implementation=ErrorInformation.class))}, description="Ein Fehler ist im NCPeH Simulator aufgetreten.")})
    public Response retrieveDocument(RetrieveDocumentRequest var1);
}

