/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ncpeh.api.mock.builder;

import de.gematik.ncpeh.api.mock.builder.Constants;
import de.gematik.ncpeh.api.mock.http.PseudoHttpRequest;
import de.gematik.ncpeh.api.mock.http.PseudoHttpResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

/*
 * Exception performing whole class analysis ignored.
 */
public final class HttpMessageFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpMessageFactory.class);
    public static final String RESOURCES_FOLDER = "src/main/resources/";
    public static final String SPRING_BOOT_CLASSES_FOLDER = "BOOT-INF/classes/";
    public static final String MESSAGES_FOLDER = "messages/";
    public static final String PATIENT_IDENTIFICATION_REQUEST_FILE_NAME = "PRPA_IN201305UV02.xml";
    public static final String PATIENT_IDENTIFICATION_RESPONSE_FILE_NAME = "PRPA_IN201306UV02.xml";
    public static final String FIND_DOCUMENT_REQUEST_FILE_NAME = "AdhocQueryRequest.xml";
    public static final String FIND_DOCUMENT_RESPONSE_FILE_NAME = "AdhocQueryResponse.xml";
    public static final String RETRIEVE_DOCUMENT_REQUEST_FILE_NAME = "RetrieveDocumentRequest.xml";
    public static final String RETRIEVE_DOCUMENT_RESPONSE_FILE_NAME = "RetrieveDocumentResponse.xml";
    private static final AtomicReference<Object> resourceLoader = new AtomicReference();

    public static PseudoHttpRequest buildStandardIdentifyPatientRequest() {
        return HttpMessageFactory.buildHttpRequest((String)"PRPA_IN201305UV02.xml");
    }

    public static PseudoHttpRequest buildStandardFindDocumentRequest() {
        return HttpMessageFactory.buildHttpRequest((String)"AdhocQueryRequest.xml");
    }

    public static PseudoHttpRequest buildStandardRetrieveDocumentRequest() {
        return HttpMessageFactory.buildHttpRequest((String)"RetrieveDocumentRequest.xml");
    }

    public static PseudoHttpResponse buildStandardIdentifyPatientResponse() {
        return HttpMessageFactory.buildHttpResponse((String)"PRPA_IN201306UV02.xml");
    }

    public static PseudoHttpResponse buildStandardFindDocumentResponse() {
        return HttpMessageFactory.buildHttpResponse((String)"AdhocQueryResponse.xml");
    }

    public static PseudoHttpResponse buildStandardRetrieveDocumentResponse() {
        return HttpMessageFactory.buildHttpResponse((String)"RetrieveDocumentResponse.xml");
    }

    public static String readFileContentFromPath(String filePath) {
        Resource fileResource = Optional.ofNullable(filePath).map(HttpMessageFactory::getReadableFileResource).or(() -> Optional.ofNullable(filePath).map(fp -> "src/main/resources/" + fp).map(HttpMessageFactory::getReadableFileResource)).or(() -> Optional.ofNullable(filePath).map(fp -> "classpath:" + fp).map(HttpMessageFactory::getReadableFileResource)).or(() -> Optional.ofNullable(filePath).map(fp -> "classpath:BOOT-INF/classes/" + fp).map(HttpMessageFactory::getReadableFileResource)).or(() -> Optional.ofNullable(filePath).map(HttpMessageFactory::findReadableFileResource)).orElseThrow(() -> new FileNotFoundException("No file with path " + filePath + " found in the common locations"));
        return new String(fileResource.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
    }

    private static PseudoHttpRequest buildHttpRequest(@NonNull String bodyDataFilePath) {
        Objects.requireNonNull(bodyDataFilePath, "bodyDataFilePath is marked non-null but is null");
        PseudoHttpRequest httpRequest = new PseudoHttpRequest().setMethod(HttpMethod.POST).setURI(Constants.PSEUDO_URI).setRequestBody(HttpMessageFactory.readFileContentToOutputStream((String)("messages/" + bodyDataFilePath)));
        HttpHeaders headers = httpRequest.getHeaders();
        headers.setAccept(List.of(MediaType.TEXT_XML, Constants.APPLICATION_SOAP_XML));
        headers.setContentType(Constants.APPLICATION_SOAP_XML);
        headers.setContentLength((long)Optional.ofNullable(httpRequest.getRequestBody()).map(ByteArrayOutputStream::size).orElse(0).intValue());
        return httpRequest;
    }

    private static ByteArrayOutputStream readFileContentToOutputStream(@NonNull String filePath) {
        Objects.requireNonNull(filePath, "filePath is marked non-null but is null");
        ByteArrayOutputStream body = new ByteArrayOutputStream();
        body.writeBytes(HttpMessageFactory.readFileContentFromPath((String)filePath).getBytes(StandardCharsets.UTF_8));
        return body;
    }

    private static PseudoHttpResponse buildHttpResponse(@NonNull String bodyDataFilePath) {
        Objects.requireNonNull(bodyDataFilePath, "bodyDataFilePath is marked non-null but is null");
        byte[] body = HttpMessageFactory.readFileContentFromPath((String)("messages/" + bodyDataFilePath)).getBytes(StandardCharsets.UTF_8);
        try (PseudoHttpResponse httpResponse = new PseudoHttpResponse(HttpStatus.OK).setBody((InputStream)new ByteArrayInputStream(body));){
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(Constants.APPLICATION_SOAP_XML);
            headers.setAccept(List.of(Constants.APPLICATION_SOAP_XML, MediaType.TEXT_XML));
            headers.setContentLength((long)body.length);
            PseudoHttpResponse pseudoHttpResponse = httpResponse.setHeaders(headers);
            return pseudoHttpResponse;
        }
    }

    private static Resource getReadableFileResource(@NonNull String filePath) {
        Objects.requireNonNull(filePath, "filePath is marked non-null but is null");
        Resource resource = HttpMessageFactory.resourceLoader().getResource(filePath);
        log.debug("Current resource attempt: {}", (Object)resource);
        if (resource.exists() && resource.isReadable()) {
            return resource;
        }
        return null;
    }

    private static Resource findReadableFileResource(@NonNull String filePath) {
        Objects.requireNonNull(filePath, "filePath is marked non-null but is null");
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resolver.getResources("classpath:**");
        return Arrays.stream(resources).filter(resource -> Objects.nonNull(resource.getFilename())).filter(resource -> resource.getFilename().endsWith(filePath)).filter(Resource::isReadable).findFirst().orElse(null);
    }

    @Generated
    private HttpMessageFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static ResourceLoader resourceLoader() {
        Object value = resourceLoader.get();
        if (value == null) {
            AtomicReference atomicReference = resourceLoader;
            synchronized (atomicReference) {
                value = resourceLoader.get();
                if (value == null) {
                    DefaultResourceLoader actualValue = new DefaultResourceLoader();
                    value = actualValue == null ? resourceLoader : actualValue;
                    resourceLoader.set(value);
                }
            }
        }
        return value == resourceLoader ? null : value;
    }
}

