/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.v3;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.cxf.xjc.runtime.JAXBToStringStyle;
import org.hl7.v3.BIN;
import org.hl7.v3.BinaryDataEncoding;
import org.hl7.v3.CompressionAlgorithm;
import org.hl7.v3.IntegrityCheckAlgorithm;
import org.hl7.v3.ST;
import org.hl7.v3.Thumbnail;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ED")
@XmlSeeAlso(value={Thumbnail.class, ST.class})
public class ED
extends BIN {
    @XmlAttribute(name="mediaType")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String mediaType;
    @XmlAttribute(name="language")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String language;
    @XmlAttribute(name="compression")
    protected CompressionAlgorithm compression;
    @XmlAttribute(name="integrityCheck")
    protected byte[] integrityCheck;
    @XmlAttribute(name="integrityCheckAlgorithm")
    protected IntegrityCheckAlgorithm integrityCheckAlgorithm;

    public String getMediaType() {
        if (this.mediaType == null) {
            return "text/plain";
        }
        return this.mediaType;
    }

    public void setMediaType(String value) {
        this.mediaType = value;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String value) {
        this.language = value;
    }

    public CompressionAlgorithm getCompression() {
        return this.compression;
    }

    public void setCompression(CompressionAlgorithm value) {
        this.compression = value;
    }

    public byte[] getIntegrityCheck() {
        return this.integrityCheck;
    }

    public void setIntegrityCheck(byte[] value) {
        this.integrityCheck = value;
    }

    public IntegrityCheckAlgorithm getIntegrityCheckAlgorithm() {
        if (this.integrityCheckAlgorithm == null) {
            return IntegrityCheckAlgorithm.SHA_1;
        }
        return this.integrityCheckAlgorithm;
    }

    public void setIntegrityCheckAlgorithm(IntegrityCheckAlgorithm value) {
        this.integrityCheckAlgorithm = value;
    }

    public ED withMediaType(String value) {
        this.setMediaType(value);
        return this;
    }

    public ED withLanguage(String value) {
        this.setLanguage(value);
        return this;
    }

    public ED withCompression(CompressionAlgorithm value) {
        this.setCompression(value);
        return this;
    }

    public ED withIntegrityCheck(byte[] value) {
        this.setIntegrityCheck(value);
        return this;
    }

    public ED withIntegrityCheckAlgorithm(IntegrityCheckAlgorithm value) {
        this.setIntegrityCheckAlgorithm(value);
        return this;
    }

    @Override
    public ED withContent(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getContent().add(value);
            }
        }
        return this;
    }

    @Override
    public ED withContent(Collection<String> values) {
        if (values != null) {
            this.getContent().addAll(values);
        }
        return this;
    }

    @Override
    public ED withRepresentation(BinaryDataEncoding value) {
        this.setRepresentation(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ED that = (ED)object;
        String leftMediaType = this.getMediaType();
        String rightMediaType = that.getMediaType();
        if (this.mediaType != null) {
            if (that.mediaType == null) return false;
            if (!leftMediaType.equals(rightMediaType)) {
                return false;
            }
        } else if (that.mediaType != null) {
            return false;
        }
        String leftLanguage = this.getLanguage();
        String rightLanguage = that.getLanguage();
        if (this.language != null) {
            if (that.language == null) return false;
            if (!leftLanguage.equals(rightLanguage)) {
                return false;
            }
        } else if (that.language != null) {
            return false;
        }
        CompressionAlgorithm leftCompression = this.getCompression();
        CompressionAlgorithm rightCompression = that.getCompression();
        if (this.compression != null) {
            if (that.compression == null) return false;
            if (!leftCompression.equals((Object)rightCompression)) {
                return false;
            }
        } else if (that.compression != null) {
            return false;
        }
        byte[] leftIntegrityCheck = this.getIntegrityCheck();
        byte[] rightIntegrityCheck = that.getIntegrityCheck();
        if (this.integrityCheck != null) {
            if (that.integrityCheck == null) return false;
            if (!Arrays.equals(leftIntegrityCheck, rightIntegrityCheck)) {
                return false;
            }
        } else if (that.integrityCheck != null) {
            return false;
        }
        IntegrityCheckAlgorithm leftIntegrityCheckAlgorithm = this.getIntegrityCheckAlgorithm();
        IntegrityCheckAlgorithm rightIntegrityCheckAlgorithm = that.getIntegrityCheckAlgorithm();
        if (this.integrityCheckAlgorithm != null) {
            if (that.integrityCheckAlgorithm == null) return false;
            if (leftIntegrityCheckAlgorithm.equals((Object)rightIntegrityCheckAlgorithm)) return true;
            return false;
        }
        if (that.integrityCheckAlgorithm == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        String theMediaType = this.getMediaType();
        if (this.mediaType != null) {
            currentHashCode += theMediaType.hashCode();
        }
        currentHashCode *= 31;
        String theLanguage = this.getLanguage();
        if (this.language != null) {
            currentHashCode += theLanguage.hashCode();
        }
        currentHashCode *= 31;
        CompressionAlgorithm theCompression = this.getCompression();
        if (this.compression != null) {
            currentHashCode += theCompression.hashCode();
        }
        currentHashCode *= 31;
        byte[] theIntegrityCheck = this.getIntegrityCheck();
        currentHashCode += Arrays.hashCode(theIntegrityCheck);
        currentHashCode *= 31;
        IntegrityCheckAlgorithm theIntegrityCheckAlgorithm = this.getIntegrityCheckAlgorithm();
        if (this.integrityCheckAlgorithm != null) {
            currentHashCode += theIntegrityCheckAlgorithm.hashCode();
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)JAXBToStringStyle.DEFAULT_STYLE);
    }
}

