/*
 * Decompiled with CFR 0.152.
 */
package de.gccc.jib;

import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.buildplan.ImageFormat;
import com.google.cloud.tools.jib.api.buildplan.Platform;
import com.google.cloud.tools.jib.api.buildplan.Port;
import com.google.cloud.tools.jib.docker.CliDockerClient;
import de.gccc.jib.SbtConfiguration;
import de.gccc.jib.common.JibCommon$;
import java.io.File;
import java.io.Serializable;
import java.util.Set;
import sbt.internal.util.ManagedLogger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class SbtDockerBuild$ {
    public static SbtDockerBuild$ MODULE$;

    static {
        new SbtDockerBuild$();
    }

    public ImageReference task(File targetDirectory, ManagedLogger logger, SbtConfiguration configuration, Option<String> jibBaseImageCredentialHelper, List<String> jvmFlags, List<Object> tcpPorts, List<Object> udpPorts, List<String> args, Option<List<String>> entryPoint, Map<String, String> environment, Map<String, String> labels, List<String> additionalTags, Option<String> user, boolean useCurrentTimestamp, scala.collection.immutable.Set<Platform> platforms) {
        ImageReference imageReference;
        if (!CliDockerClient.isDefaultDockerInstalled()) {
            throw new Exception("Build to Docker daemon failed");
        }
        try {
            DockerDaemonImage targetImage = DockerDaemonImage.named((ImageReference)configuration.targetImageReference());
            Containerizer taggedImage = Containerizer.to((DockerDaemonImage)targetImage);
            JibCommon$.MODULE$.configureContainerizer(taggedImage, additionalTags, configuration.allowInsecureRegistries(), configuration.USER_AGENT_SUFFIX(), targetDirectory.toPath());
            RegistryImage baseImage = JibCommon$.MODULE$.baseImageFactory(configuration.baseImageReference(), jibBaseImageCredentialHelper, configuration.credsForHost(), (Function1 & Serializable & scala.Serializable)logEvent -> {
                configuration.logEvent(logEvent);
                return BoxedUnit.UNIT;
            });
            JibContainer container = Jib.from((RegistryImage)baseImage).setFileEntriesLayers(configuration.getLayerConfigurations()).setUser((String)user.orNull(Predef$.MODULE$.$conforms())).setEnvironment((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(environment).asJava()).setPlatforms((Set)JavaConverters$.MODULE$.setAsJavaSetConverter(platforms).asJava()).setLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(labels).asJava()).setProgramArguments((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(args).asJava()).setFormat(ImageFormat.Docker).setEntrypoint(configuration.entrypoint(jvmFlags, entryPoint)).setExposedPorts((Set)JavaConverters$.MODULE$.setAsJavaSetConverter(((SetLike)tcpPorts.toSet().map((Function1 & Serializable & scala.Serializable)s -> SbtDockerBuild$.$anonfun$task$2(BoxesRunTime.unboxToInt((Object)s)), Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)udpPorts.toSet().map((Function1 & Serializable & scala.Serializable)s -> SbtDockerBuild$.$anonfun$task$3(BoxesRunTime.unboxToInt((Object)s)), Set$.MODULE$.canBuildFrom()))).asJava()).setCreationTime(JibCommon$.MODULE$.useCurrentTimestamp(useCurrentTimestamp)).containerize(taggedImage);
            JibCommon$.MODULE$.writeJibOutputFiles(container, targetDirectory.toPath());
            logger.success((Function0 & Serializable & scala.Serializable)() -> "image successfully created & uploaded");
            imageReference = configuration.targetImageReference();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                logger.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("could not create docker image (Exception: ").append(t).append(")").toString());
                throw t;
            }
            throw throwable;
        }
        return imageReference;
    }

    public static final /* synthetic */ Port $anonfun$task$2(int s) {
        return Port.tcp((int)s);
    }

    public static final /* synthetic */ Port $anonfun$task$3(int s) {
        return Port.udp((int)s);
    }

    private SbtDockerBuild$() {
        MODULE$ = this;
    }
}

