/*
 * Decompiled with CFR 0.152.
 */
package de.gccc.jib;

import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.CredentialRetriever;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.buildplan.ImageFormat;
import com.google.cloud.tools.jib.api.buildplan.Platform;
import com.google.cloud.tools.jib.api.buildplan.Port;
import com.google.cloud.tools.jib.frontend.CredentialRetrieverFactory;
import de.gccc.jib.SbtLayerConfigurations;
import de.gccc.jib.TimestampHelper$;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.compat.java8.FunctionConverters.package$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.compat.java8.functionConverterImpls.RichFunction1AsConsumer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JibCommon$ {
    public static JibCommon$ MODULE$;

    static {
        new JibCommon$();
    }

    private boolean isSnapshotDependency(Path path) {
        return ((Object)path).toString().endsWith("-SNAPSHOT.jar");
    }

    private void addToClasspath(JavaContainerBuilder builder, Seq<Tuple2<File, String>> mappings, Function1<String, BoxedUnit> loggerWarn) {
        builder.addToClasspath((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)mappings.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            File file = (File)tuple2._1();
            String ignored = (String)tuple2._2();
            String string = file.toString();
            String string2 = ignored;
            Object object = (string == null ? string2 != null : !string.equals(string2)) ? loggerWarn.apply((Object)new StringBuilder(71).append("The file `").append(file).append("` won't be mapped to `").append(ignored).append("` in the container, but directly to `").append(file).append("`.").toString()) : BoxedUnit.UNIT;
            Path path = file.toPath();
            return path;
        }, Seq$.MODULE$.canBuildFrom())).asJava());
    }

    public JavaContainerBuilder prepareJavaContainerBuilder(JavaContainerBuilder builder, SbtLayerConfigurations layerConfigurations, Option<String> mainClass, List<String> jvmFlags, Function1<String, BoxedUnit> loggerWarn) {
        builder.addDependencies((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)layerConfigurations.external().map((Function1 & Serializable & scala.Serializable)x$1 -> ((File)x$1.data()).toPath(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)JibCommon$.MODULE$.isSnapshotDependency(path)))).asJava());
        builder.addSnapshotDependencies((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)layerConfigurations.external().map((Function1 & Serializable & scala.Serializable)x$2 -> ((File)x$2.data()).toPath(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)JibCommon$.MODULE$.isSnapshotDependency(path)))).asJava());
        this.addToClasspath(builder, layerConfigurations.mappings(), loggerWarn);
        this.addToClasspath(builder, layerConfigurations.extraMappings(), loggerWarn);
        builder.addProjectDependencies((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)layerConfigurations.internalDependencies().map((Function1 & Serializable & scala.Serializable)x$3 -> ((File)x$3.data()).toPath(), Seq$.MODULE$.canBuildFrom())).asJava());
        ((IterableLike)layerConfigurations.resourceDirectories().filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.exists()))).foreach((Function1 & Serializable & scala.Serializable)f -> builder.addResources(f.toPath()));
        ((IterableLike)layerConfigurations.classes().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.exists()))).foreach((Function1 & Serializable & scala.Serializable)f -> builder.addClasses(f.toPath(), p -> ((Object)p).toString().endsWith(".class")));
        return builder.setMainClass((String)mainClass.orNull(Predef$.MODULE$.$conforms())).addJvmFlags((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(jvmFlags).asJava());
    }

    public JibContainerBuilder prepareJibContainerBuilder(JibContainerBuilder builder, scala.collection.immutable.Set<Port> ports, List<String> args, ImageFormat internalImageFormat, scala.collection.immutable.Map<String, String> environment, scala.collection.immutable.Map<String, String> labels, Option<String> user, boolean useCurrentTimestamp, scala.collection.immutable.Set<Platform> platforms) {
        return builder.setEnvironment((Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(environment).asJava()).setPlatforms((Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(platforms).asJava()).setLabels((Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(labels).asJava()).setUser((String)user.orNull(Predef$.MODULE$.$conforms())).setProgramArguments((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(args).asJava()).setFormat(internalImageFormat).setExposedPorts((Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(ports).asJava()).setCreationTime(TimestampHelper$.MODULE$.useCurrentTimestamp(useCurrentTimestamp));
    }

    private RegistryImage imageFactory(ImageReference imageReference, Tuple2<String, String> credentialsEnv, Option<String> credHelper, Function1<String, Option<Tuple2<String, String>>> credsForHost, Function1<LogEvent, BoxedUnit> logger) {
        RegistryImage image = RegistryImage.named((ImageReference)imageReference);
        CredentialRetrieverFactory factory = CredentialRetrieverFactory.forImage((ImageReference)imageReference, (Consumer)RichFunction1AsConsumer$.MODULE$.asJava$extension(package$.MODULE$.enrichAsJavaConsumer(logger)));
        Tuple2<String, String> tuple2 = credentialsEnv;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String usernameEnv = (String)tuple2._1();
        String passwordEnv = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)usernameEnv, (Object)passwordEnv);
        Tuple2 tuple23 = tuple22;
        String usernameEnv2 = (String)tuple23._1();
        String passwordEnv2 = (String)tuple23._2();
        image.addCredentialRetriever(this.retrieveEnvCredentials(usernameEnv2, passwordEnv2));
        image.addCredentialRetriever(this.retrieveSbtCredentials(imageReference, credsForHost));
        image.addCredentialRetriever(factory.dockerConfig());
        image.addCredentialRetriever(factory.wellKnownCredentialHelpers());
        image.addCredentialRetriever(factory.googleApplicationDefaultCredentials());
        credHelper.foreach((Function1 & Serializable & scala.Serializable)helper -> image.addCredentialRetriever(factory.dockerCredentialHelper(helper)));
        return image;
    }

    private CredentialRetriever retrieveEnvCredentials(String usernameEnv, String passwordEnv) {
        return () -> {
            Option option = scala.sys.package$.MODULE$.env().get((Object)usernameEnv).flatMap((Function1 & Serializable & scala.Serializable)username -> scala.sys.package$.MODULE$.env().get((Object)passwordEnv).map((Function1 & Serializable & scala.Serializable)password -> Credential.from((String)username, (String)password)));
            return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(option));
        };
    }

    private CredentialRetriever retrieveSbtCredentials(ImageReference imageReference, Function1<String, Option<Tuple2<String, String>>> credsForHost) {
        return () -> {
            Option option = ((Option)credsForHost.apply((Object)imageReference.getRegistry())).map(((Function2 & Serializable & scala.Serializable)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> Credential.from((String)x$1, (String)x$2)).tupled());
            return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(option));
        };
    }

    public RegistryImage baseImageFactory(ImageReference baseImageReference, Option<String> jibBaseImageCredentialHelper, Function1<String, Option<Tuple2<String, String>>> credsForHost, Function1<LogEvent, BoxedUnit> logger) {
        return this.imageFactory(baseImageReference, (Tuple2<String, String>)new Tuple2((Object)"JIB_BASE_IMAGE_USERNAME", (Object)"JIB_BASE_IMAGE_PASSWORD"), jibBaseImageCredentialHelper, credsForHost, logger);
    }

    public RegistryImage targetImageFactory(ImageReference targetImageReference, Option<String> jibTargetImageCredentialHelper, Function1<String, Option<Tuple2<String, String>>> credsForHost, Function1<LogEvent, BoxedUnit> logger) {
        return this.imageFactory(targetImageReference, (Tuple2<String, String>)new Tuple2((Object)"JIB_TARGET_IMAGE_USERNAME", (Object)"JIB_TARGET_IMAGE_PASSWORD"), jibTargetImageCredentialHelper, credsForHost, logger);
    }

    public void configureContainerizer(Containerizer containerizer, List<String> additionalTags, boolean allowInsecureRegistries, String USER_AGENT_SUFFIX, File target) {
        additionalTags.foldRight((Object)containerizer, (Function2 & Serializable & scala.Serializable)(tag, image) -> image.withAdditionalTag(tag));
        containerizer.setAllowInsecureRegistries(allowInsecureRegistries).setToolName(USER_AGENT_SUFFIX).setApplicationLayersCache(target.toPath().resolve("application-layer-cache")).setBaseImageLayersCache(target.toPath().resolve("base-image-layer-cache"));
    }

    public void writeJibOutputFiles(JibContainer container, File targetDirectory) {
        Files.write(targetDirectory.toPath().resolve("jib-image.digest"), container.getDigest().toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(targetDirectory.toPath().resolve("jib-image.id"), container.getImageId().toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String jsonString = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(121).append("{\n         |   \"image\": \"").append(container.getTargetImage()).append("\",\n         |   \"imageId\": \"").append(container.getImageId()).append("\",\n         |   \"imageDigest\": \"").append(container.getDigest()).append("\",\n         |   \"tags\": ").append(((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(container.getTags()).asScala()).mkString("[\"", "\", \"", "\"]")).append("\n         |}").toString())).stripMargin();
        Files.write(targetDirectory.toPath().resolve("jib-image.json"), jsonString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public void setSendCredentialsOverHttp(boolean sendCredentialsOverHttp) {
        System.setProperty("sendCredentialsOverHttp", Boolean.toString(sendCredentialsOverHttp));
    }

    private JibCommon$() {
        MODULE$ = this;
    }
}

