/*
 * Decompiled with CFR 0.152.
 */
package de.gccc.jib;

import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.TarImage;
import com.google.cloud.tools.jib.api.buildplan.ImageFormat;
import com.google.cloud.tools.jib.api.buildplan.Port;
import de.gccc.jib.JibPlugin;
import de.gccc.jib.JibPlugin$autoImport$JibImageFormat$Docker$;
import de.gccc.jib.JibPlugin$autoImport$JibImageFormat$OCI$;
import de.gccc.jib.SbtConfiguration;
import de.gccc.jib.SbtJibHelper$;
import de.gccc.jib.TimestampHelper$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Set;
import sbt.internal.util.ManagedLogger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class SbtTarImageBuild$ {
    public static SbtTarImageBuild$ MODULE$;

    static {
        new SbtTarImageBuild$();
    }

    public void task(File targetDirectory, File home, ManagedLogger logger, SbtConfiguration configuration, Option<String> jibBaseImageCredentialHelper, List<String> jvmFlags, List<Object> tcpPorts, List<Object> udpPorts, List<String> args, Option<List<String>> entrypoint, JibPlugin.autoImport.JibImageFormat imageFormat, Map<String, String> environment, Map<String, String> labels, List<String> additionalTags, Option<String> user, boolean useCurrentTimestamp) {
        ImageFormat imageFormat2;
        JibPlugin.autoImport.JibImageFormat jibImageFormat = imageFormat;
        if (JibPlugin$autoImport$JibImageFormat$Docker$.MODULE$.equals(jibImageFormat)) {
            imageFormat2 = ImageFormat.Docker;
        } else if (JibPlugin$autoImport$JibImageFormat$OCI$.MODULE$.equals(jibImageFormat)) {
            imageFormat2 = ImageFormat.OCI;
        } else {
            throw new MatchError((Object)jibImageFormat);
        }
        ImageFormat internalImageFormat = imageFormat2;
        try {
            ImageReference imageReference = ImageReference.of((String)configuration.registry(), (String)configuration.repository(), (String)configuration.version());
            TarImage targetImage = TarImage.at((Path)home.toPath()).named(imageReference);
            Containerizer taggedImage = (Containerizer)additionalTags.foldRight((Object)Containerizer.to((TarImage)targetImage), (Function2 & Serializable & scala.Serializable)(tag, image) -> image.withAdditionalTag(tag));
            JibContainer container = Jib.from((RegistryImage)configuration.baseImageFactory(jibBaseImageCredentialHelper)).setFileEntriesLayers(configuration.getLayerConfigurations()).setEnvironment((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(environment).asJava()).setLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(labels).asJava()).setUser((String)user.orNull(Predef$.MODULE$.$conforms())).setProgramArguments((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(args).asJava()).setFormat(internalImageFormat).setEntrypoint(configuration.entrypoint(jvmFlags, entrypoint)).setExposedPorts((Set)JavaConverters$.MODULE$.setAsJavaSetConverter(((SetLike)tcpPorts.toSet().map((Function1 & Serializable & scala.Serializable)s -> SbtTarImageBuild$.$anonfun$task$2(BoxesRunTime.unboxToInt((Object)s)), Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)udpPorts.toSet().map((Function1 & Serializable & scala.Serializable)s -> SbtTarImageBuild$.$anonfun$task$3(BoxesRunTime.unboxToInt((Object)s)), Set$.MODULE$.canBuildFrom()))).asJava()).setCreationTime(TimestampHelper$.MODULE$.useCurrentTimestamp(useCurrentTimestamp)).containerize(configuration.configureContainerizer(taggedImage));
            SbtJibHelper$.MODULE$.writeJibOutputFiles(targetDirectory, container);
            logger.success((Function0 & Serializable & scala.Serializable)() -> "image successfully created & uploaded");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                logger.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("could not create tar image (Exception: ").append(t).append(")").toString());
                throw t;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ Port $anonfun$task$2(int s) {
        return Port.tcp((int)s);
    }

    public static final /* synthetic */ Port $anonfun$task$3(int s) {
        return Port.udp((int)s);
    }

    private SbtTarImageBuild$() {
        MODULE$ = this;
    }
}

