/*
 * Decompiled with CFR 0.152.
 */
package de.gccc.jib;

import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.TarImage;
import com.google.cloud.tools.jib.api.buildplan.ImageFormat;
import com.google.cloud.tools.jib.api.buildplan.Platform;
import de.gccc.jib.JibPlugin;
import de.gccc.jib.JibPlugin$autoImport$JibImageFormat$Docker$;
import de.gccc.jib.JibPlugin$autoImport$JibImageFormat$OCI$;
import de.gccc.jib.SbtConfiguration;
import de.gccc.jib.SbtJavaCommon$;
import de.gccc.jib.SbtJibHelper$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import sbt.internal.util.ManagedLogger;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.util.control.NonFatal$;

public final class SbtJavaTarImageBuild$ {
    public static SbtJavaTarImageBuild$ MODULE$;

    static {
        new SbtJavaTarImageBuild$();
    }

    public void task(File targetDirectory, File home, ManagedLogger logger, SbtConfiguration configuration, Option<String> jibBaseImageCredentialHelper, List<String> jvmFlags, List<Object> tcpPorts, List<Object> udpPorts, List<String> args, JibPlugin.autoImport.JibImageFormat imageFormat, Map<String, String> environment, Map<String, String> labels, List<String> additionalTags, Option<String> user, boolean useCurrentTimestamp, Set<Platform> platforms) {
        ImageFormat imageFormat2;
        JibPlugin.autoImport.JibImageFormat jibImageFormat = imageFormat;
        if (JibPlugin$autoImport$JibImageFormat$Docker$.MODULE$.equals(jibImageFormat)) {
            imageFormat2 = ImageFormat.Docker;
        } else if (JibPlugin$autoImport$JibImageFormat$OCI$.MODULE$.equals(jibImageFormat)) {
            imageFormat2 = ImageFormat.OCI;
        } else {
            throw new MatchError((Object)jibImageFormat);
        }
        ImageFormat internalImageFormat = imageFormat2;
        try {
            ImageReference imageReference = ImageReference.of((String)configuration.registry(), (String)configuration.repository(), (String)configuration.version());
            TarImage targetImage = TarImage.at((Path)home.toPath()).named(imageReference);
            Containerizer taggedImage = (Containerizer)additionalTags.foldRight((Object)Containerizer.to((TarImage)targetImage), (Function2 & Serializable & scala.Serializable)(tag, image) -> image.withAdditionalTag(tag));
            JibContainerBuilder builder = SbtJavaCommon$.MODULE$.prepareJavaContainerBuilder(JavaContainerBuilder.from((RegistryImage)configuration.baseImageFactory(jibBaseImageCredentialHelper)), configuration.layerConfigurations(), (Option<String>)new Some((Object)configuration.pickedMainClass()), jvmFlags).toContainerBuilder();
            JibContainer container = SbtJavaCommon$.MODULE$.prepareJibContainerBuilder(builder, tcpPorts, udpPorts, args, internalImageFormat, environment, labels, user, useCurrentTimestamp, platforms).containerize(configuration.configureContainerizer(taggedImage));
            SbtJibHelper$.MODULE$.writeJibOutputFiles(targetDirectory, container);
            logger.success((Function0 & Serializable & scala.Serializable)() -> "java image successfully created & uploaded");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                logger.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("could not create java tar image (Exception: ").append(t).append(")").toString());
                throw t;
            }
            throw throwable;
        }
    }

    private SbtJavaTarImageBuild$() {
        MODULE$ = this;
    }
}

