/*
 * Decompiled with CFR 0.152.
 */
package de.gccc.jib;

import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.buildplan.ImageFormat;
import com.google.cloud.tools.jib.api.buildplan.Platform;
import com.google.cloud.tools.jib.docker.CliDockerClient;
import de.gccc.jib.SbtConfiguration;
import de.gccc.jib.SbtJavaCommon$;
import de.gccc.jib.SbtJibHelper$;
import java.io.File;
import java.io.Serializable;
import sbt.internal.util.ManagedLogger;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.util.control.NonFatal$;

public final class SbtJavaDockerBuild$ {
    public static SbtJavaDockerBuild$ MODULE$;

    static {
        new SbtJavaDockerBuild$();
    }

    public ImageReference task(File targetDirectory, ManagedLogger logger, SbtConfiguration configuration, Option<String> jibBaseImageCredentialHelper, List<String> jvmFlags, List<Object> tcpPorts, List<Object> udpPorts, List<String> args, Map<String, String> environment, Map<String, String> labels, List<String> additionalTags, Option<String> user, boolean useCurrentTimestamp, Set<Platform> platforms) {
        ImageReference imageReference;
        if (!CliDockerClient.isDefaultDockerInstalled()) {
            throw new Exception("Build to Docker daemon failed");
        }
        try {
            DockerDaemonImage targetImage = DockerDaemonImage.named((ImageReference)configuration.targetImageReference());
            Containerizer taggedImage = (Containerizer)additionalTags.foldRight((Object)Containerizer.to((DockerDaemonImage)targetImage), (Function2 & Serializable & scala.Serializable)(tag, image) -> image.withAdditionalTag(tag));
            JibContainerBuilder builder = SbtJavaCommon$.MODULE$.prepareJavaContainerBuilder(JavaContainerBuilder.from((RegistryImage)configuration.baseImageFactory(jibBaseImageCredentialHelper)), configuration.layerConfigurations(), (Option<String>)new Some((Object)configuration.pickedMainClass()), jvmFlags).toContainerBuilder();
            JibContainer container = SbtJavaCommon$.MODULE$.prepareJibContainerBuilder(builder, tcpPorts, udpPorts, args, ImageFormat.Docker, environment, labels, user, useCurrentTimestamp, platforms).containerize(configuration.configureContainerizer(taggedImage));
            SbtJibHelper$.MODULE$.writeJibOutputFiles(targetDirectory, container);
            logger.success((Function0 & Serializable & scala.Serializable)() -> "java image successfully created & uploaded");
            imageReference = configuration.targetImageReference();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                logger.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("could not create java docker image (Exception: ").append(t).append(")").toString());
                throw t;
            }
            throw throwable;
        }
        return imageReference;
    }

    private SbtJavaDockerBuild$() {
        MODULE$ = this;
    }
}

