/*
 * Decompiled with CFR 0.152.
 */
package de.gccc.jib;

import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.buildplan.ImageFormat;
import com.google.cloud.tools.jib.docker.DockerClient;
import de.gccc.jib.SbtConfiguration;
import de.gccc.jib.TimestampHelper$;
import java.io.File;
import java.io.Serializable;
import sbt.internal.util.ManagedLogger;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.util.control.NonFatal$;

public final class SbtDockerBuild$ {
    public static SbtDockerBuild$ MODULE$;
    private final String USER_AGENT_SUFFIX;

    static {
        new SbtDockerBuild$();
    }

    private String USER_AGENT_SUFFIX() {
        return this.USER_AGENT_SUFFIX;
    }

    public ImageReference task(ManagedLogger logger, SbtConfiguration configuration, Option<String> jibBaseImageCredentialHelper, Option<String> jibTargetImageCredentialHelper, String defaultImage, List<String> jvmFlags, List<String> args, Option<List<String>> entryPoint, Map<String, String> environment, Map<String, String> labels, Option<String> user, boolean useCurrentTimestamp, File target) {
        if (!DockerClient.isDefaultDockerInstalled()) {
            throw new Exception("Build to Docker daemon failed");
        }
        try {
            DockerDaemonImage targetImage = DockerDaemonImage.named((ImageReference)configuration.targetImageReference());
            Containerizer containerizer = Containerizer.to((DockerDaemonImage)targetImage).setToolName(this.USER_AGENT_SUFFIX()).setApplicationLayersCache(target.toPath().resolve("application-layer-cache")).setBaseImageLayersCache(target.toPath().resolve("base-image-layer-cache"));
            Jib.from((RegistryImage)configuration.baseImageFactory(jibTargetImageCredentialHelper)).setFileEntriesLayers(configuration.getLayerConfigurations()).setUser((String)user.orNull(Predef$.MODULE$.$conforms())).setEnvironment((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(environment).asJava()).setLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(labels).asJava()).setProgramArguments((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(args).asJava()).setFormat(ImageFormat.Docker).setEntrypoint(configuration.entrypoint(jvmFlags, entryPoint)).setCreationTime(TimestampHelper$.MODULE$.useCurrentTimestamp(useCurrentTimestamp)).containerize(containerizer);
            logger.success((Function0 & Serializable & scala.Serializable)() -> "image successfully created & uploaded");
            return configuration.targetImageReference();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                logger.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("could not create docker image (Exception: ").append(t).append(")").toString());
                throw t;
            }
            throw throwable;
        }
    }

    private SbtDockerBuild$() {
        MODULE$ = this;
        this.USER_AGENT_SUFFIX = "jib-sbt-plugin";
    }
}

