/*
 * Decompiled with CFR 0.152.
 */
package de.gccc.jib;

import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.image.ImageFormat;
import com.google.cloud.tools.jib.image.ImageReference;
import de.gccc.jib.SbtConfiguration;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import sbt.internal.util.ManagedLogger;
import scala.Function0;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class SbtDockerBuild$ {
    public static SbtDockerBuild$ MODULE$;
    private final String USER_AGENT_SUFFIX;

    static {
        new SbtDockerBuild$();
    }

    private String USER_AGENT_SUFFIX() {
        return this.USER_AGENT_SUFFIX;
    }

    public void task(ManagedLogger logger, SbtConfiguration configuration, Option<String> jibBaseImageCredentialHelper, Option<String> jibTargetImageCredentialHelper, String defaultImage, List<String> jvmFlags, List<String> args, Map<String, String> environment) {
        if (!DockerClient.isDefaultDockerInstalled()) {
            throw new Exception("Build to Docker daemon failed");
        }
        try {
            DockerDaemonImage targetImage = DockerDaemonImage.named((ImageReference)configuration.targetImageReference());
            Containerizer containerizer = Containerizer.to((DockerDaemonImage)targetImage).setToolName(this.USER_AGENT_SUFFIX()).setApplicationLayersCache(Files.createTempDirectory("jib-application-layer-cache", new FileAttribute[0])).setBaseImageLayersCache(Files.createTempDirectory("jib-base-image-layer-cache", new FileAttribute[0]));
            Jib.from((RegistryImage)configuration.baseImageFactory(jibTargetImageCredentialHelper)).setLayers(configuration.getLayerConfigurations()).setEnvironment((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(environment).asJava()).setProgramArguments((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(args).asJava()).setFormat(ImageFormat.Docker).setEntrypoint(configuration.entrypoint(jvmFlags)).containerize(containerizer);
            logger.success((Function0 & Serializable & scala.Serializable)() -> "image successfully created & uploaded");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                logger.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("could not create docker image (Exception: ").append(t).append(")").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private SbtDockerBuild$() {
        MODULE$ = this;
        this.USER_AGENT_SUFFIX = "jib-sbt-plugin";
    }
}

