/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.cloud.tools.jib.image.UnwrittenLayer;
import com.google.cloud.tools.jib.tar.TarStreamBuilder;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;

public class ReproducibleLayerBuilder {
    private final ImmutableList.Builder<LayerEntry> layerEntries = ImmutableList.builder();

    private static List<TarArchiveEntry> buildAsTarArchiveEntries(LayerEntry layerEntry) throws IOException {
        ArrayList<TarArchiveEntry> arrayList = new ArrayList<TarArchiveEntry>();
        for (Path path : layerEntry.getSourceFiles()) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                new DirectoryWalker(path).filterRoot().walk(path2 -> {
                    StringBuilder stringBuilder = new StringBuilder(layerEntry.getExtractionPath());
                    Path path3 = path.getParent().relativize(path2);
                    for (Path path4 : path3) {
                        stringBuilder.append('/').append(path4);
                    }
                    arrayList.add(new TarArchiveEntry(path2.toFile(), stringBuilder.toString()));
                });
                continue;
            }
            TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(path.toFile(), layerEntry.getExtractionPath() + "/" + path.getFileName());
            arrayList.add(tarArchiveEntry);
        }
        return arrayList;
    }

    public ReproducibleLayerBuilder addFiles(List<Path> list, String string) {
        this.layerEntries.add((Object)new LayerEntry((ImmutableList<Path>)ImmutableList.copyOf(list), string));
        return this;
    }

    public UnwrittenLayer build() throws IOException {
        ArrayList<TarArchiveEntry> arrayList = new ArrayList<TarArchiveEntry>();
        for (Object object : this.layerEntries.build()) {
            arrayList.addAll(ReproducibleLayerBuilder.buildAsTarArchiveEntries((LayerEntry)object));
        }
        arrayList.sort(Comparator.comparing(TarArchiveEntry::getName));
        TarStreamBuilder tarStreamBuilder = new TarStreamBuilder();
        for (TarArchiveEntry tarArchiveEntry : arrayList) {
            tarArchiveEntry.setModTime(0L);
            tarArchiveEntry.setGroupId(0);
            tarArchiveEntry.setUserId(0);
            tarArchiveEntry.setUserName("");
            tarArchiveEntry.setGroupName("");
            tarStreamBuilder.addTarArchiveEntry(tarArchiveEntry);
        }
        return new UnwrittenLayer(tarStreamBuilder.toBlob());
    }

    public ImmutableList<LayerEntry> getLayerEntries() {
        return this.layerEntries.build();
    }
}

