/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.cloud.tools.jib.image.json.DescriptorDigestDeserializer;
import com.google.cloud.tools.jib.image.json.DescriptorDigestSerializer;
import java.security.DigestException;

@JsonSerialize(using=DescriptorDigestSerializer.class)
@JsonDeserialize(using=DescriptorDigestDeserializer.class)
public class DescriptorDigest {
    private static final String HASH_REGEX = "[a-f0-9]{64}";
    private static final String DIGEST_PREFIX = "sha256:";
    static final String DIGEST_REGEX = "sha256:[a-f0-9]{64}";
    private final String hash;

    public static DescriptorDigest fromHash(String string) throws DigestException {
        if (!string.matches(HASH_REGEX)) {
            throw new DigestException("Invalid hash: " + string);
        }
        return new DescriptorDigest(string);
    }

    public static DescriptorDigest fromDigest(String string) throws DigestException {
        if (!string.matches(DIGEST_REGEX)) {
            throw new DigestException("Invalid digest: " + string);
        }
        String string2 = string.substring(DIGEST_PREFIX.length());
        return new DescriptorDigest(string2);
    }

    private DescriptorDigest(String string) {
        this.hash = string;
    }

    public String getHash() {
        return this.hash;
    }

    public String toString() {
        return DIGEST_PREFIX + this.hash;
    }

    public int hashCode() {
        return this.hash.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DescriptorDigest) {
            return this.hash.equals(((DescriptorDigest)object).hash);
        }
        return false;
    }
}

