/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.cloud.tools.jib.configuration.Port;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExposedPortsParser {
    private static final Pattern portPattern = Pattern.compile("(\\d+)(?:-(\\d+))?(?:/(tcp|udp))?");

    public static ImmutableList<Port> parse(List<String> list) throws NumberFormatException {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (String string : list) {
            int n;
            Matcher matcher = portPattern.matcher(string);
            if (!matcher.matches()) {
                throw new NumberFormatException("Invalid port configuration: '" + string + "'. Make sure the port is a single number or a range of two numbers separated with a '-', with or without protocol specified (e.g. '<portNum>/tcp' or '<portNum>/udp').");
            }
            int n2 = n = Integer.parseInt(matcher.group(1));
            if (!Strings.isNullOrEmpty((String)matcher.group(2))) {
                n2 = Integer.parseInt(matcher.group(2));
            }
            Port.Protocol protocol = Port.Protocol.getFromString(matcher.group(3));
            if (n > n2) {
                throw new NumberFormatException("Invalid port range '" + string + "'; smaller number must come first.");
            }
            if (n < 1 || n2 > 65535) {
                throw new NumberFormatException("Port number '" + string + "' is out of usual range (1-65535).");
            }
            for (int i = n; i <= n2; ++i) {
                builder.add((Object)new Port(i, protocol));
            }
        }
        return builder.build();
    }

    private ExposedPortsParser() {
    }
}

