/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.filesystem.UserCacheHome;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class CacheConfiguration {
    @VisibleForTesting
    static final Path DEFAULT_BASE_CACHE_DIRECTORY = UserCacheHome.getCacheHome().resolve("google-cloud-tools-java").resolve("jib");
    private final Path cacheDirectory;
    private final boolean shouldEnsureOwnership;

    public static CacheConfiguration forPath(Path path) {
        return new CacheConfiguration(path, true);
    }

    public static CacheConfiguration makeTemporary() throws CacheDirectoryCreationException {
        try {
            Path path = Files.createTempDirectory(null, new FileAttribute[0]);
            path.toFile().deleteOnExit();
            return new CacheConfiguration(path, false);
        }
        catch (IOException iOException) {
            throw new CacheDirectoryCreationException(iOException);
        }
    }

    public static CacheConfiguration forDefaultUserLevelCacheDirectory() {
        return new CacheConfiguration(DEFAULT_BASE_CACHE_DIRECTORY, true);
    }

    private CacheConfiguration(Path path, boolean bl) {
        this.cacheDirectory = path;
        this.shouldEnsureOwnership = bl;
    }

    public Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    public boolean shouldEnsureOwnership() {
        return this.shouldEnsureOwnership;
    }
}

