/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.configuration.CacheConfiguration;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.lang.model.SourceVersion;

public class BuildConfiguration {
    private final BuildLogger buildLogger;
    private final Instant creationTime;
    private final ImageReference baseImageReference;
    @Nullable
    private final String baseImageCredentialHelperName;
    @Nullable
    private final RegistryCredentials knownBaseRegistryCredentials;
    private final ImageReference targetImageReference;
    @Nullable
    private final String targetImageCredentialHelperName;
    @Nullable
    private final RegistryCredentials knownTargetRegistryCredentials;
    @Nullable
    private final ImmutableList<String> javaArguments;
    @Nullable
    private final ImmutableMap<String, String> environmentMap;
    @Nullable
    private final ImmutableList<Port> exposedPorts;
    private final Class<? extends BuildableManifestTemplate> targetFormat;
    @Nullable
    private final CacheConfiguration applicationLayersCacheConfiguration;
    @Nullable
    private final CacheConfiguration baseImageLayersCacheConfiguration;
    private final boolean allowInsecureRegistries;
    private final ImmutableList<LayerConfiguration> layerConfigurations;
    @Nullable
    private final ImmutableList<String> entrypoint;

    public static boolean isValidJavaClass(String string) {
        for (String string2 : Splitter.on((char)'.').split((CharSequence)string)) {
            if (SourceVersion.isIdentifier(string2)) continue;
            return false;
        }
        return true;
    }

    public static Builder builder(BuildLogger buildLogger) {
        return new Builder(buildLogger);
    }

    private BuildConfiguration(BuildLogger buildLogger, Instant instant, ImageReference imageReference, @Nullable String string, @Nullable RegistryCredentials registryCredentials, ImageReference imageReference2, @Nullable String string2, @Nullable RegistryCredentials registryCredentials2, @Nullable ImmutableList<String> immutableList, @Nullable ImmutableMap<String, String> immutableMap, @Nullable ImmutableList<Port> immutableList2, Class<? extends BuildableManifestTemplate> clazz, @Nullable CacheConfiguration cacheConfiguration, @Nullable CacheConfiguration cacheConfiguration2, boolean bl, ImmutableList<LayerConfiguration> immutableList3, @Nullable ImmutableList<String> immutableList4) {
        this.buildLogger = buildLogger;
        this.creationTime = instant;
        this.baseImageReference = imageReference;
        this.baseImageCredentialHelperName = string;
        this.knownBaseRegistryCredentials = registryCredentials;
        this.targetImageReference = imageReference2;
        this.targetImageCredentialHelperName = string2;
        this.knownTargetRegistryCredentials = registryCredentials2;
        this.javaArguments = immutableList;
        this.environmentMap = immutableMap;
        this.exposedPorts = immutableList2;
        this.targetFormat = clazz;
        this.applicationLayersCacheConfiguration = cacheConfiguration;
        this.baseImageLayersCacheConfiguration = cacheConfiguration2;
        this.allowInsecureRegistries = bl;
        this.layerConfigurations = immutableList3;
        this.entrypoint = immutableList4;
    }

    public BuildLogger getBuildLogger() {
        return this.buildLogger;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public ImageReference getBaseImageReference() {
        return this.baseImageReference;
    }

    public String getBaseImageRegistry() {
        return this.baseImageReference.getRegistry();
    }

    public String getBaseImageRepository() {
        return this.baseImageReference.getRepository();
    }

    public String getBaseImageTag() {
        return this.baseImageReference.getTag();
    }

    @Nullable
    public String getBaseImageCredentialHelperName() {
        return this.baseImageCredentialHelperName;
    }

    @Nullable
    public RegistryCredentials getKnownBaseRegistryCredentials() {
        return this.knownBaseRegistryCredentials;
    }

    public ImageReference getTargetImageReference() {
        return this.targetImageReference;
    }

    public String getTargetImageRegistry() {
        return this.targetImageReference.getRegistry();
    }

    public String getTargetImageRepository() {
        return this.targetImageReference.getRepository();
    }

    public String getTargetImageTag() {
        return this.targetImageReference.getTag();
    }

    @Nullable
    public String getTargetImageCredentialHelperName() {
        return this.targetImageCredentialHelperName;
    }

    @Nullable
    public RegistryCredentials getKnownTargetRegistryCredentials() {
        return this.knownTargetRegistryCredentials;
    }

    @Nullable
    public ImmutableList<String> getJavaArguments() {
        return this.javaArguments;
    }

    @Nullable
    public ImmutableMap<String, String> getEnvironment() {
        return this.environmentMap;
    }

    @Nullable
    public ImmutableList<Port> getExposedPorts() {
        return this.exposedPorts;
    }

    public Class<? extends BuildableManifestTemplate> getTargetFormat() {
        return this.targetFormat;
    }

    @Nullable
    public CacheConfiguration getApplicationLayersCacheConfiguration() {
        return this.applicationLayersCacheConfiguration;
    }

    @Nullable
    public CacheConfiguration getBaseImageLayersCacheConfiguration() {
        return this.baseImageLayersCacheConfiguration;
    }

    public boolean getAllowInsecureRegistries() {
        return this.allowInsecureRegistries;
    }

    public ImmutableList<LayerConfiguration> getLayerConfigurations() {
        return this.layerConfigurations;
    }

    @Nullable
    public ImmutableList<String> getEntrypoint() {
        return this.entrypoint;
    }

    public static class Builder {
        private Instant creationTime = Instant.EPOCH;
        @Nullable
        private ImageReference baseImageReference;
        @Nullable
        private String baseImageCredentialHelperName;
        @Nullable
        private RegistryCredentials knownBaseRegistryCredentials;
        @Nullable
        private ImageReference targetImageReference;
        @Nullable
        private String targetImageCredentialHelperName;
        @Nullable
        private RegistryCredentials knownTargetRegistryCredentials;
        @Nullable
        private ImmutableList<String> javaArguments;
        @Nullable
        private ImmutableMap<String, String> environmentMap;
        @Nullable
        private ImmutableList<Port> exposedPorts;
        private Class<? extends BuildableManifestTemplate> targetFormat = V22ManifestTemplate.class;
        @Nullable
        private CacheConfiguration applicationLayersCacheConfiguration;
        @Nullable
        private CacheConfiguration baseImageLayersCacheConfiguration;
        private boolean allowInsecureRegistries = false;
        private ImmutableList<LayerConfiguration> layerConfigurations = ImmutableList.of();
        @Nullable
        private ImmutableList<String> entrypoint;
        private BuildLogger buildLogger;

        private Builder(BuildLogger buildLogger) {
            this.buildLogger = buildLogger;
        }

        public Builder setBaseImage(@Nullable ImageReference imageReference) {
            this.baseImageReference = imageReference;
            return this;
        }

        public Builder setTargetImage(@Nullable ImageReference imageReference) {
            this.targetImageReference = imageReference;
            return this;
        }

        public Builder setBaseImageCredentialHelperName(@Nullable String string) {
            this.baseImageCredentialHelperName = string;
            return this;
        }

        public Builder setTargetImageCredentialHelperName(@Nullable String string) {
            this.targetImageCredentialHelperName = string;
            return this;
        }

        public Builder setKnownBaseRegistryCredentials(@Nullable RegistryCredentials registryCredentials) {
            this.knownBaseRegistryCredentials = registryCredentials;
            return this;
        }

        public Builder setKnownTargetRegistryCredentials(@Nullable RegistryCredentials registryCredentials) {
            this.knownTargetRegistryCredentials = registryCredentials;
            return this;
        }

        public Builder setJavaArguments(@Nullable List<String> list) {
            if (list != null) {
                Preconditions.checkArgument((!list.contains(null) ? 1 : 0) != 0);
                this.javaArguments = ImmutableList.copyOf(list);
            }
            return this;
        }

        public Builder setEnvironment(@Nullable Map<String, String> map) {
            if (map == null) {
                this.environmentMap = null;
            } else {
                Preconditions.checkArgument((!Iterables.any(map.keySet(), Objects::isNull) && !Iterables.any(map.values(), Objects::isNull) ? 1 : 0) != 0);
                this.environmentMap = ImmutableMap.copyOf(map);
            }
            return this;
        }

        public Builder setExposedPorts(@Nullable List<Port> list) {
            if (list == null) {
                this.exposedPorts = null;
            } else {
                Preconditions.checkArgument((!list.contains(null) ? 1 : 0) != 0);
                this.exposedPorts = ImmutableList.copyOf(list);
            }
            return this;
        }

        public Builder setTargetFormat(Class<? extends BuildableManifestTemplate> clazz) {
            this.targetFormat = clazz;
            return this;
        }

        public Builder setApplicationLayersCacheConfiguration(@Nullable CacheConfiguration cacheConfiguration) {
            this.applicationLayersCacheConfiguration = cacheConfiguration;
            return this;
        }

        public Builder setBaseImageLayersCacheConfiguration(@Nullable CacheConfiguration cacheConfiguration) {
            this.baseImageLayersCacheConfiguration = cacheConfiguration;
            return this;
        }

        public Builder setAllowInsecureRegistries(boolean bl) {
            this.allowInsecureRegistries = bl;
            return this;
        }

        public Builder setLayerConfigurations(List<LayerConfiguration> list) {
            this.layerConfigurations = ImmutableList.copyOf(list);
            return this;
        }

        public Builder setCreationTime(Instant instant) {
            this.creationTime = instant;
            return this;
        }

        public Builder setEntrypoint(@Nullable List<String> list) {
            if (list == null) {
                this.entrypoint = null;
            } else {
                Preconditions.checkArgument((!list.contains(null) ? 1 : 0) != 0);
                this.entrypoint = ImmutableList.copyOf(list);
            }
            return this;
        }

        public BuildConfiguration build() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.baseImageReference == null) {
                arrayList.add("base image is required but not set");
            }
            if (this.targetImageReference == null) {
                arrayList.add("target image is required but not set");
            }
            switch (arrayList.size()) {
                case 0: {
                    if (this.baseImageReference == null || this.targetImageReference == null) {
                        throw new IllegalStateException("Required fields should not be null");
                    }
                    if (this.baseImageReference.usesDefaultTag()) {
                        this.buildLogger.warn("Base image '" + this.baseImageReference + "' does not use a specific image digest - build may not be reproducible");
                    }
                    return new BuildConfiguration(this.buildLogger, this.creationTime, this.baseImageReference, this.baseImageCredentialHelperName, this.knownBaseRegistryCredentials, this.targetImageReference, this.targetImageCredentialHelperName, this.knownTargetRegistryCredentials, this.javaArguments, this.environmentMap, this.exposedPorts, this.targetFormat, this.applicationLayersCacheConfiguration, this.baseImageLayersCacheConfiguration, this.allowInsecureRegistries, this.layerConfigurations, this.entrypoint);
                }
                case 1: {
                    throw new IllegalStateException((String)arrayList.get(0));
                }
                case 2: {
                    throw new IllegalStateException((String)arrayList.get(0) + " and " + (String)arrayList.get(1));
                }
            }
            throw new IllegalStateException();
        }
    }
}

