/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.cache.CacheDirectoryNotOwnedException;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class Caches
implements Closeable {
    private final Cache baseCache;
    private final Cache applicationCache;

    private Caches(Path path, Path path2) throws CacheMetadataCorruptedException, IOException {
        this.applicationCache = Cache.init(path2);
        this.baseCache = Files.isSameFile(path, path2) ? this.applicationCache : Cache.init(path);
    }

    public Cache getBaseCache() {
        return this.baseCache;
    }

    public Cache getApplicationCache() {
        return this.applicationCache;
    }

    @Override
    public void close() throws IOException {
        this.applicationCache.close();
        if (this.baseCache != this.applicationCache) {
            this.baseCache.close();
        }
    }

    public static class Initializer {
        private static final String OWNERSHIP_FILE_NAME = ".jib";
        private final Path baseImageLayersCacheDirectory;
        private final boolean shouldEnsureOwnershipOfBaseImageLayersCacheDirectory;
        private final Path applicationLayersCacheDirectory;
        private final boolean shouldEnsureOwnershipOfApplicationLayersCacheDirectory;

        @VisibleForTesting
        static void ensureOwnership(Path path) throws CacheDirectoryNotOwnedException, CacheDirectoryCreationException {
            Path path2 = path.resolve(OWNERSHIP_FILE_NAME);
            if (Files.exists(path, new LinkOption[0])) {
                if (!Files.exists(path2, new LinkOption[0])) {
                    throw new CacheDirectoryNotOwnedException(path);
                }
            } else {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                    Files.createFile(path2, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    throw new CacheDirectoryCreationException(path, (Throwable)iOException);
                }
            }
        }

        public Initializer(Path path, boolean bl, Path path2, boolean bl2) {
            this.baseImageLayersCacheDirectory = path;
            this.shouldEnsureOwnershipOfBaseImageLayersCacheDirectory = bl;
            this.applicationLayersCacheDirectory = path2;
            this.shouldEnsureOwnershipOfApplicationLayersCacheDirectory = bl2;
        }

        public Caches init() throws CacheMetadataCorruptedException, CacheDirectoryNotOwnedException, CacheDirectoryCreationException, IOException {
            if (this.shouldEnsureOwnershipOfBaseImageLayersCacheDirectory) {
                Initializer.ensureOwnership(this.baseImageLayersCacheDirectory);
            }
            if (this.shouldEnsureOwnershipOfApplicationLayersCacheDirectory) {
                Initializer.ensureOwnership(this.applicationLayersCacheDirectory);
            }
            return new Caches(this.baseImageLayersCacheDirectory, this.applicationLayersCacheDirectory);
        }
    }
}

