/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.builder.steps.AuthenticatePushStep;
import com.google.cloud.tools.jib.builder.steps.PushBlobStep;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class PushLayersStep
implements AsyncStep<ImmutableList<AsyncStep<PushBlobStep>>>,
Callable<ImmutableList<AsyncStep<PushBlobStep>>> {
    private static final String DESCRIPTION = "Setting up to push layers";
    private final BuildConfiguration buildConfiguration;
    private final AuthenticatePushStep authenticatePushStep;
    private final AsyncStep<? extends ImmutableList<? extends AsyncStep<? extends CachedLayer>>> cachedLayerStepsStep;
    private final ListeningExecutorService listeningExecutorService;
    private final ListenableFuture<ImmutableList<AsyncStep<PushBlobStep>>> listenableFuture;

    PushLayersStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, AuthenticatePushStep authenticatePushStep, AsyncStep<? extends ImmutableList<? extends AsyncStep<? extends CachedLayer>>> asyncStep) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
        this.authenticatePushStep = authenticatePushStep;
        this.cachedLayerStepsStep = asyncStep;
        this.listenableFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{asyncStep.getFuture()}).call((Callable)this, (Executor)listeningExecutorService);
    }

    @Override
    public ListenableFuture<ImmutableList<AsyncStep<PushBlobStep>>> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public ImmutableList<AsyncStep<PushBlobStep>> call() throws ExecutionException {
        try (Timer timer = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION);){
            ImmutableList<? extends AsyncStep<? extends CachedLayer>> immutableList = NonBlockingSteps.get(this.cachedLayerStepsStep);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (AsyncStep asyncStep : immutableList) {
                ListenableFuture listenableFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{asyncStep.getFuture()}).call(() -> this.makePushBlobStep(asyncStep), (Executor)this.listeningExecutorService);
                builder.add(() -> listenableFuture);
            }
            UnmodifiableIterator unmodifiableIterator = builder.build();
            return unmodifiableIterator;
        }
    }

    private PushBlobStep makePushBlobStep(AsyncStep<? extends CachedLayer> asyncStep) throws ExecutionException {
        CachedLayer cachedLayer = NonBlockingSteps.get(asyncStep);
        return new PushBlobStep(this.listeningExecutorService, this.buildConfiguration, this.authenticatePushStep, cachedLayer.getBlobDescriptor(), cachedLayer.getBlob());
    }
}

