/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.builder.steps.RetrieveRegistryCredentialsStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerCountMismatchException;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.BadContainerConfigurationFormatException;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.JsonToImageTranslator;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.image.json.UnknownManifestFormatException;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.cloud.tools.jib.registry.RegistryUnauthorizedException;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

class PullBaseImageStep
implements AsyncStep<BaseImageWithAuthorization>,
Callable<BaseImageWithAuthorization> {
    private static final String DESCRIPTION = "Pulling base image manifest";
    private final BuildConfiguration buildConfiguration;
    private final ListenableFuture<BaseImageWithAuthorization> listenableFuture;

    PullBaseImageStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
        this.listenableFuture = listeningExecutorService.submit((Callable)this);
    }

    @Override
    public ListenableFuture<BaseImageWithAuthorization> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public BaseImageWithAuthorization call() throws IOException, RegistryException, LayerPropertyNotFoundException, LayerCountMismatchException, ExecutionException, BadContainerConfigurationFormatException, RegistryAuthenticationFailedException {
        this.buildConfiguration.getBuildLogger().lifecycle("Getting base image " + this.buildConfiguration.getBaseImageReference() + "...");
        Throwable throwable = null;
        try (Timer timer = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION);){
            BaseImageWithAuthorization baseImageWithAuthorization = new BaseImageWithAuthorization(this.pullBaseImage(null), null);
            return baseImageWithAuthorization;
        }
        catch (RegistryUnauthorizedException registryUnauthorizedException) {
            this.buildConfiguration.getBuildLogger().lifecycle("The base image requires auth. Trying again for " + this.buildConfiguration.getBaseImageReference() + "...");
            ListeningExecutorService listeningExecutorService = MoreExecutors.newDirectExecutorService();
            RetrieveRegistryCredentialsStep retrieveRegistryCredentialsStep = RetrieveRegistryCredentialsStep.forBaseImage(listeningExecutorService, this.buildConfiguration);
            Authorization authorization = NonBlockingSteps.get(retrieveRegistryCredentialsStep);
            try {
                BaseImageWithAuthorization baseImageWithAuthorization = new BaseImageWithAuthorization(this.pullBaseImage(authorization), authorization);
                return baseImageWithAuthorization;
            }
            catch (RegistryUnauthorizedException registryUnauthorizedException2) {
                RegistryAuthenticator registryAuthenticator = RegistryAuthenticator.initializer(this.buildConfiguration.getBaseImageRegistry(), this.buildConfiguration.getBaseImageRepository()).setAllowInsecureRegistries(this.buildConfiguration.getAllowInsecureRegistries()).initialize();
                if (registryAuthenticator == null) {
                    this.buildConfiguration.getBuildLogger().error("Failed to retrieve authentication challenge for registry that required token authentication");
                    throw registryUnauthorizedException2;
                }
                authorization = registryAuthenticator.setAuthorization(authorization).authenticatePull();
                BaseImageWithAuthorization baseImageWithAuthorization = new BaseImageWithAuthorization(this.pullBaseImage(authorization), authorization);
                return baseImageWithAuthorization;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private Image<Layer> pullBaseImage(@Nullable Authorization authorization) throws IOException, RegistryException, LayerPropertyNotFoundException, LayerCountMismatchException, BadContainerConfigurationFormatException {
        RegistryClient registryClient = RegistryClient.factory(this.buildConfiguration.getBaseImageRegistry(), this.buildConfiguration.getBaseImageRepository()).setAllowInsecureRegistries(this.buildConfiguration.getAllowInsecureRegistries()).setAuthorization(authorization).newRegistryClient();
        ManifestTemplate manifestTemplate = registryClient.pullManifest(this.buildConfiguration.getBaseImageTag());
        switch (manifestTemplate.getSchemaVersion()) {
            case 1: {
                V21ManifestTemplate v21ManifestTemplate = (V21ManifestTemplate)manifestTemplate;
                return JsonToImageTranslator.toImage(v21ManifestTemplate);
            }
            case 2: {
                V22ManifestTemplate v22ManifestTemplate = (V22ManifestTemplate)manifestTemplate;
                if (v22ManifestTemplate.getContainerConfiguration() == null || v22ManifestTemplate.getContainerConfiguration().getDigest() == null) {
                    throw new UnknownManifestFormatException("Invalid container configuration in Docker V2.2 manifest: \n" + Blobs.writeToString(JsonTemplateMapper.toBlob(v22ManifestTemplate)));
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                registryClient.pullBlob(v22ManifestTemplate.getContainerConfiguration().getDigest(), byteArrayOutputStream);
                String string = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
                ContainerConfigurationTemplate containerConfigurationTemplate = JsonTemplateMapper.readJson(string, ContainerConfigurationTemplate.class);
                return JsonToImageTranslator.toImage(v22ManifestTemplate, containerConfigurationTemplate);
            }
        }
        throw new IllegalStateException("Unknown manifest schema version");
    }

    static class BaseImageWithAuthorization {
        private final Image<Layer> baseImage;
        @Nullable
        private final Authorization baseImageAuthorization;

        private BaseImageWithAuthorization(Image<Layer> image, @Nullable Authorization authorization) {
            this.baseImage = image;
            this.baseImageAuthorization = authorization;
        }

        Image<Layer> getBaseImage() {
            return this.baseImage;
        }

        @Nullable
        Authorization getBaseImageAuthorization() {
            return this.baseImageAuthorization;
        }
    }
}

