/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.builder.steps.StepsRunner;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.cache.CacheDirectoryNotOwnedException;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.Caches;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;

public class BuildSteps {
    private static final String DESCRIPTION_FOR_DOCKER_REGISTRY = "Building and pushing image";
    private static final String STARTUP_MESSAGE_FORMAT_FOR_DOCKER_REGISTRY = "Containerizing application to %s...";
    private static final String SUCCESS_MESSAGE_FORMAT_FOR_DOCKER_REGISTRY = "Built and pushed image as \u001b[36m%s\u001b[0m";
    private static final String DESCRIPTION_FOR_DOCKER_DAEMON = "Building image to Docker daemon";
    private static final String STARTUP_MESSAGE_FORMAT_FOR_DOCKER_DAEMON = "Containerizing application to Docker daemon as %s...";
    private static final String SUCCESS_MESSAGE_FORMAT_FOR_DOCKER_DAEMON = "Built image to Docker daemon as \u001b[36m%s\u001b[0m";
    private static final String DESCRIPTION_FOR_TARBALL = "Building image tarball";
    private static final String STARTUP_MESSAGE_FORMAT_FOR_TARBALL = "Containerizing application to file at '%s'...";
    private static final String SUCCESS_MESSAGE_FORMAT_FOR_TARBALL = "Built image tarball at \u001b[36m%s\u001b[0m";
    private final String description;
    private final BuildConfiguration buildConfiguration;
    private final Caches.Initializer cachesInitializer;
    private final String startupMessage;
    private final String successMessage;
    private final StepsRunnerConsumer stepsRunnerConsumer;

    public static BuildSteps forBuildToDockerRegistry(BuildConfiguration buildConfiguration, Caches.Initializer initializer) {
        return new BuildSteps(DESCRIPTION_FOR_DOCKER_REGISTRY, buildConfiguration, initializer, String.format(STARTUP_MESSAGE_FORMAT_FOR_DOCKER_REGISTRY, buildConfiguration.getTargetImageReference()), String.format(SUCCESS_MESSAGE_FORMAT_FOR_DOCKER_REGISTRY, buildConfiguration.getTargetImageReference()), stepsRunner -> stepsRunner.runRetrieveTargetRegistryCredentialsStep().runAuthenticatePushStep().runPullBaseImageStep().runPullAndCacheBaseImageLayersStep().runPushBaseImageLayersStep().runBuildAndCacheApplicationLayerSteps().runBuildImageStep().runPushContainerConfigurationStep().runPushApplicationLayersStep().runFinalizingPushStep().runPushImageStep().waitOnPushImageStep());
    }

    public static BuildSteps forBuildToDockerDaemon(BuildConfiguration buildConfiguration, Caches.Initializer initializer) {
        return new BuildSteps(DESCRIPTION_FOR_DOCKER_DAEMON, buildConfiguration, initializer, String.format(STARTUP_MESSAGE_FORMAT_FOR_DOCKER_DAEMON, buildConfiguration.getTargetImageReference()), String.format(SUCCESS_MESSAGE_FORMAT_FOR_DOCKER_DAEMON, buildConfiguration.getTargetImageReference()), stepsRunner -> stepsRunner.runPullBaseImageStep().runPullAndCacheBaseImageLayersStep().runBuildAndCacheApplicationLayerSteps().runBuildImageStep().runFinalizingBuildStep().runLoadDockerStep().waitOnLoadDockerStep());
    }

    public static BuildSteps forBuildToTar(Path path, BuildConfiguration buildConfiguration, Caches.Initializer initializer) {
        return new BuildSteps(DESCRIPTION_FOR_TARBALL, buildConfiguration, initializer, String.format(STARTUP_MESSAGE_FORMAT_FOR_TARBALL, path.toString()), String.format(SUCCESS_MESSAGE_FORMAT_FOR_TARBALL, path.toString()), stepsRunner -> stepsRunner.runPullBaseImageStep().runPullAndCacheBaseImageLayersStep().runBuildAndCacheApplicationLayerSteps().runBuildImageStep().runFinalizingBuildStep().runWriteTarFileStep(path).waitOnWriteTarFileStep());
    }

    private BuildSteps(String string, BuildConfiguration buildConfiguration, Caches.Initializer initializer, String string2, String string3, StepsRunnerConsumer stepsRunnerConsumer) {
        this.description = string;
        this.buildConfiguration = buildConfiguration;
        this.cachesInitializer = initializer;
        this.startupMessage = string2;
        this.successMessage = string3;
        this.stepsRunnerConsumer = stepsRunnerConsumer;
    }

    public BuildConfiguration getBuildConfiguration() {
        return this.buildConfiguration;
    }

    public String getStartupMessage() {
        return this.startupMessage;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void run() throws InterruptedException, ExecutionException, CacheMetadataCorruptedException, IOException, CacheDirectoryNotOwnedException, CacheDirectoryCreationException {
        this.buildConfiguration.getBuildLogger().lifecycle("");
        try (Timer timer = new Timer(this.buildConfiguration.getBuildLogger(), this.description);
             Caches caches = this.cachesInitializer.init();){
            Cache cache = caches.getBaseCache();
            Cache cache2 = caches.getApplicationCache();
            StepsRunner stepsRunner = new StepsRunner(this.buildConfiguration, cache, cache2);
            this.stepsRunnerConsumer.accept(stepsRunner);
            cache.addCachedLayersToMetadata(stepsRunner.getCachedBaseImageLayers());
            cache2.addCachedLayersWithMetadataToMetadata(stepsRunner.getCachedApplicationLayers());
        }
        this.buildConfiguration.getBuildLogger().lifecycle("");
        this.buildConfiguration.getBuildLogger().lifecycle("Container entrypoint set to " + this.buildConfiguration.getEntrypoint());
    }

    @FunctionalInterface
    private static interface StepsRunnerConsumer {
        public void accept(StepsRunner var1) throws ExecutionException, InterruptedException;
    }
}

