/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.blob;

import com.google.cloud.tools.jib.hash.CountingDigestOutputStream;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BlobDescriptor {
    private final DescriptorDigest digest;
    private final long size;

    static BlobDescriptor fromPipe(InputStream inputStream, OutputStream outputStream) throws IOException {
        CountingDigestOutputStream countingDigestOutputStream = new CountingDigestOutputStream(outputStream);
        ByteStreams.copy((InputStream)inputStream, (OutputStream)countingDigestOutputStream);
        countingDigestOutputStream.flush();
        return countingDigestOutputStream.toBlobDescriptor();
    }

    public BlobDescriptor(long l, DescriptorDigest descriptorDigest) {
        this.size = l;
        this.digest = descriptorDigest;
    }

    public BlobDescriptor(DescriptorDigest descriptorDigest) {
        this(-1L, descriptorDigest);
    }

    public boolean hasSize() {
        return this.size >= 0L;
    }

    public DescriptorDigest getDigest() {
        return this.digest;
    }

    public long getSize() {
        return this.size;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (this.size < 0L || !(object instanceof BlobDescriptor)) {
            return false;
        }
        BlobDescriptor blobDescriptor = (BlobDescriptor)object;
        return this.size == blobDescriptor.getSize() && this.digest.equals(blobDescriptor.getDigest());
    }

    public int hashCode() {
        int n = this.digest.hashCode();
        n = 31 * n + (int)(this.size ^ this.size >>> 32);
        return n;
    }

    public String toString() {
        return "digest: " + this.digest + ", size: " + this.size;
    }
}

