/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry.credentials;

import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelper;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelperFactory;
import com.google.cloud.tools.jib.registry.credentials.json.DockerConfigTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;

class DockerConfig {
    private final DockerConfigTemplate dockerConfigTemplate;

    @Nullable
    private static <K, T> Map.Entry<K, T> findFirstInMapByKey(Map<K, T> map, List<Predicate<K>> list) {
        return list.stream().map(predicate -> DockerConfig.findFirstInMapByKey(map, predicate)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    private static <K, T> Map.Entry<K, T> findFirstInMapByKey(Map<K, T> map, Predicate<K> predicate) {
        return map.entrySet().stream().filter(entry -> predicate.test(entry.getKey())).findFirst().orElse(null);
    }

    DockerConfig(DockerConfigTemplate dockerConfigTemplate) {
        this.dockerConfigTemplate = dockerConfigTemplate;
    }

    @Nullable
    String getAuthFor(String string) {
        Map.Entry<String, DockerConfigTemplate.AuthTemplate> entry = DockerConfig.findFirstInMapByKey(this.dockerConfigTemplate.getAuths(), this.getRegistryMatchersFor(string));
        return entry != null ? entry.getValue().getAuth() : null;
    }

    @Nullable
    @VisibleForTesting
    DockerCredentialHelper getCredentialHelperFor(String string) {
        return this.getCredentialHelperFor(new DockerCredentialHelperFactory(), string);
    }

    @Nullable
    DockerCredentialHelper getCredentialHelperFor(DockerCredentialHelperFactory dockerCredentialHelperFactory, String string) {
        List list = this.getRegistryMatchersFor(string);
        Map.Entry<String, DockerConfigTemplate.AuthTemplate> entry = DockerConfig.findFirstInMapByKey(this.dockerConfigTemplate.getAuths(), list);
        if (this.dockerConfigTemplate.getCredsStore() != null && entry != null) {
            return dockerCredentialHelperFactory.newDockerCredentialHelper(entry.getKey(), this.dockerConfigTemplate.getCredsStore());
        }
        Map.Entry<String, String> entry2 = DockerConfig.findFirstInMapByKey(this.dockerConfigTemplate.getCredHelpers(), list);
        if (entry2 == null) {
            return null;
        }
        return dockerCredentialHelperFactory.newDockerCredentialHelper(entry2.getKey(), entry2.getValue());
    }

    private List<Predicate<String>> getRegistryMatchersFor(String string) {
        Predicate<String> predicate = string::equals;
        Predicate<String> predicate2 = ("https://" + string)::equals;
        Predicate<String> predicate3 = string2 -> string2.startsWith(string + "/");
        Predicate<String> predicate4 = string2 -> string2.startsWith("https://" + string + "/");
        return Arrays.asList(predicate, predicate2, predicate3, predicate4);
    }
}

