/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Connection;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.InsecureRegistryException;
import com.google.cloud.tools.jib.registry.RegistryCredentialsNotSentException;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.cloud.tools.jib.registry.RegistryErrorExceptionBuilder;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.cloud.tools.jib.registry.RegistryNoResponseException;
import com.google.cloud.tools.jib.registry.RegistryUnauthorizedException;
import com.google.cloud.tools.jib.registry.json.ErrorEntryTemplate;
import com.google.cloud.tools.jib.registry.json.ErrorResponseTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.conn.HttpHostConnectException;

class RegistryEndpointCaller<T> {
    @VisibleForTesting
    static final int STATUS_CODE_PERMANENT_REDIRECT = 308;
    private static final String DEFAULT_PROTOCOL = "https";
    private final URL initialRequestUrl;
    private final String userAgent;
    private final RegistryEndpointProvider<T> registryEndpointProvider;
    @Nullable
    private final Authorization authorization;
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final boolean allowInsecureRegistries;
    private final Function<URL, Connection> connectionFactory;
    @Nullable
    private Function<URL, Connection> insecureConnectionFactory;

    RegistryEndpointCaller(String string, String string2, RegistryEndpointProvider<T> registryEndpointProvider, @Nullable Authorization authorization, RegistryEndpointRequestProperties registryEndpointRequestProperties, boolean bl) throws MalformedURLException {
        this(string, string2, registryEndpointProvider, authorization, registryEndpointRequestProperties, bl, Connection.getConnectionFactory(), null);
    }

    @VisibleForTesting
    RegistryEndpointCaller(String string, String string2, RegistryEndpointProvider<T> registryEndpointProvider, @Nullable Authorization authorization, RegistryEndpointRequestProperties registryEndpointRequestProperties, boolean bl, Function<URL, Connection> function, @Nullable Function<URL, Connection> function2) throws MalformedURLException {
        this.initialRequestUrl = registryEndpointProvider.getApiRoute("https://" + string2);
        this.userAgent = string;
        this.registryEndpointProvider = registryEndpointProvider;
        this.authorization = authorization;
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.allowInsecureRegistries = bl;
        this.connectionFactory = function;
        this.insecureConnectionFactory = function2;
    }

    @Nullable
    T call() throws IOException, RegistryException {
        return this.call(this.initialRequestUrl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @VisibleForTesting
    T call(URL uRL) throws IOException, RegistryException {
        boolean bl2 = "http".equals(uRL.getProtocol());
        if (!this.allowInsecureRegistries && bl2) {
            throw new InsecureRegistryException(uRL);
        }
        boolean bl = !bl2 || Boolean.getBoolean("sendCredentialsOverHttp");
        try (Connection connection = this.connectionFactory.apply(uRL);){
            Request.Builder throwable = Request.builder().setUserAgent(this.userAgent).setHttpTimeout(Integer.getInteger("jib.httpTimeout")).setAccept(this.registryEndpointProvider.getAccept()).setBody(this.registryEndpointProvider.getContent());
            if (bl) {
                throwable.setAuthorization(this.authorization);
            }
            Response registryErrorExceptionBuilder = connection.send(this.registryEndpointProvider.getHttpMethod(), throwable.build());
            T t = this.registryEndpointProvider.handleResponse(registryErrorExceptionBuilder);
            return t;
        }
        catch (HttpResponseException httpResponseException) {
            try {
                return this.registryEndpointProvider.handleHttpResponseException(httpResponseException);
            }
            catch (HttpResponseException httpResponseException2) {
                if (httpResponseException2.getStatusCode() == 400 || httpResponseException2.getStatusCode() == 404 || httpResponseException2.getStatusCode() == 405) {
                    ErrorResponseTemplate uRL2 = JsonTemplateMapper.readJson(httpResponseException2.getContent(), ErrorResponseTemplate.class);
                    RegistryErrorExceptionBuilder registryErrorExceptionBuilder = new RegistryErrorExceptionBuilder(this.registryEndpointProvider.getActionDescription(), httpResponseException2);
                    Iterator<ErrorEntryTemplate> iterator = uRL2.getErrors().iterator();
                    while (iterator.hasNext()) {
                        ErrorEntryTemplate errorEntryTemplate = iterator.next();
                        registryErrorExceptionBuilder.addReason(errorEntryTemplate);
                    }
                    throw registryErrorExceptionBuilder.build();
                }
                if (httpResponseException2.getStatusCode() == 403) {
                    throw new RegistryUnauthorizedException(this.registryEndpointRequestProperties.getServerUrl(), this.registryEndpointRequestProperties.getImageName(), httpResponseException2);
                }
                if (httpResponseException2.getStatusCode() == 401) {
                    if (!bl) throw new RegistryCredentialsNotSentException(this.registryEndpointRequestProperties.getServerUrl(), this.registryEndpointRequestProperties.getImageName());
                    throw new RegistryUnauthorizedException(this.registryEndpointRequestProperties.getServerUrl(), this.registryEndpointRequestProperties.getImageName(), httpResponseException2);
                }
                if (httpResponseException2.getStatusCode() != 307 && httpResponseException2.getStatusCode() != 301) {
                    if (httpResponseException2.getStatusCode() != 308) throw httpResponseException2;
                }
                URL uRL2 = new URL(uRL, httpResponseException2.getHeaders().getLocation());
                return this.call(uRL2);
            }
        }
        catch (SSLPeerUnverifiedException | HttpHostConnectException throwable4) {
            if (!DEFAULT_PROTOCOL.equals(uRL.getProtocol())) throw throwable4;
            GenericUrl genericUrl = new GenericUrl(uRL);
            genericUrl.setScheme("http");
            return this.call(genericUrl.toURL());
        }
        catch (NoHttpResponseException noHttpResponseException) {
            throw new RegistryNoResponseException(noHttpResponseException);
        }
    }
}

