/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.registry.AuthenticationMethodRetriever;
import com.google.cloud.tools.jib.registry.BlobChecker;
import com.google.cloud.tools.jib.registry.BlobPuller;
import com.google.cloud.tools.jib.registry.ManifestPuller;
import com.google.cloud.tools.jib.registry.ManifestPusher;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryEndpointCaller;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;

public class RegistryClient {
    private Timer parentTimer = new Timer(new BuildLogger(){

        @Override
        public void debug(CharSequence charSequence) {
        }

        @Override
        public void info(CharSequence charSequence) {
        }

        @Override
        public void warn(CharSequence charSequence) {
        }

        @Override
        public void error(CharSequence charSequence) {
        }

        @Override
        public void lifecycle(CharSequence charSequence) {
        }
    }, "NULL TIMER");
    @Nullable
    private static String userAgentSuffix;
    @Nullable
    private final Authorization authorization;
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final boolean allowInsecureRegistries;
    private final String userAgent;

    public RegistryClient setTimer(Timer timer) {
        this.parentTimer = timer;
        return this;
    }

    public static Factory factory(String string, String string2) {
        return new Factory(new RegistryEndpointRequestProperties(string, string2));
    }

    public static void setUserAgentSuffix(@Nullable String string) {
        userAgentSuffix = string;
    }

    @VisibleForTesting
    static String makeUserAgent() {
        if (!Strings.isNullOrEmpty((String)System.getProperty("_JIB_DISABLE_USER_AGENT"))) {
            return "";
        }
        String string = RegistryClient.class.getPackage().getImplementationVersion();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("jib");
        if (string != null) {
            stringBuilder.append(" ").append(string);
        }
        if (userAgentSuffix != null) {
            stringBuilder.append(" ").append(userAgentSuffix);
        }
        return stringBuilder.toString();
    }

    private RegistryClient(@Nullable Authorization authorization, RegistryEndpointRequestProperties registryEndpointRequestProperties, boolean bl, String string) {
        this.authorization = authorization;
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.allowInsecureRegistries = bl;
        this.userAgent = string;
    }

    @Nullable
    public RegistryAuthenticator getRegistryAuthenticator() throws IOException, RegistryException {
        return this.callRegistryEndpoint(new AuthenticationMethodRetriever(this.registryEndpointRequestProperties));
    }

    public <T extends ManifestTemplate> T pullManifest(String string, Class<T> clazz) throws IOException, RegistryException {
        ManifestPuller<T> manifestPuller = new ManifestPuller<T>(this.registryEndpointRequestProperties, string, clazz);
        ManifestTemplate manifestTemplate = (ManifestTemplate)this.callRegistryEndpoint(manifestPuller);
        if (manifestTemplate == null) {
            throw new IllegalStateException("ManifestPuller#handleResponse does not return null");
        }
        return (T)manifestTemplate;
    }

    public ManifestTemplate pullManifest(String string) throws IOException, RegistryException {
        return this.pullManifest(string, ManifestTemplate.class);
    }

    public void pushManifest(BuildableManifestTemplate buildableManifestTemplate, String string) throws IOException, RegistryException {
        this.callRegistryEndpoint(new ManifestPusher(this.registryEndpointRequestProperties, buildableManifestTemplate, string));
    }

    @Nullable
    public BlobDescriptor checkBlob(DescriptorDigest descriptorDigest) throws IOException, RegistryException {
        BlobChecker blobChecker = new BlobChecker(this.registryEndpointRequestProperties, descriptorDigest);
        return this.callRegistryEndpoint(blobChecker);
    }

    public Void pullBlob(DescriptorDigest descriptorDigest, OutputStream outputStream) throws RegistryException, IOException {
        BlobPuller blobPuller = new BlobPuller(this.registryEndpointRequestProperties, descriptorDigest, outputStream);
        return this.callRegistryEndpoint(blobPuller);
    }

    /*
     * Exception decompiling
     */
    public boolean pushBlob(DescriptorDigest var1_1, Blob var2_2) throws IOException, RegistryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    String getApiRouteBase() {
        return this.registryEndpointRequestProperties.getServerUrl() + "/v2/";
    }

    @VisibleForTesting
    String getUserAgent() {
        return this.userAgent;
    }

    @Nullable
    private <T> T callRegistryEndpoint(RegistryEndpointProvider<T> registryEndpointProvider) throws IOException, RegistryException {
        return new RegistryEndpointCaller<T>(this.userAgent, this.getApiRouteBase(), registryEndpointProvider, this.authorization, this.registryEndpointRequestProperties, this.allowInsecureRegistries).call();
    }

    public static class Factory {
        private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
        private boolean allowInsecureRegistries = false;
        @Nullable
        private Authorization authorization;

        private Factory(RegistryEndpointRequestProperties registryEndpointRequestProperties) {
            this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        }

        public Factory setAllowInsecureRegistries(boolean bl) {
            this.allowInsecureRegistries = bl;
            return this;
        }

        public Factory setAuthorization(@Nullable Authorization authorization) {
            this.authorization = authorization;
            return this;
        }

        public RegistryClient newRegistryClient() {
            return new RegistryClient(this.authorization, this.registryEndpointRequestProperties, this.allowInsecureRegistries, RegistryClient.makeUserAgent());
        }
    }
}

