/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;

class ManifestPusher
implements RegistryEndpointProvider<Void> {
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final BuildableManifestTemplate manifestTemplate;
    private final String imageTag;

    ManifestPusher(RegistryEndpointRequestProperties registryEndpointRequestProperties, BuildableManifestTemplate buildableManifestTemplate, String string) {
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.manifestTemplate = buildableManifestTemplate;
        this.imageTag = string;
    }

    @Override
    public BlobHttpContent getContent() {
        return new BlobHttpContent(JsonTemplateMapper.toBlob(this.manifestTemplate), this.manifestTemplate.getManifestMediaType());
    }

    @Override
    public List<String> getAccept() {
        return Collections.emptyList();
    }

    @Override
    public Void handleResponse(Response response) {
        return null;
    }

    @Override
    public URL getApiRoute(String string) throws MalformedURLException {
        return new URL(string + this.registryEndpointRequestProperties.getImageName() + "/manifests/" + this.imageTag);
    }

    @Override
    public String getHttpMethod() {
        return "PUT";
    }

    @Override
    public String getActionDescription() {
        return "push image manifest for " + this.registryEndpointRequestProperties.getServerUrl() + "/" + this.registryEndpointRequestProperties.getImageName() + ":" + this.imageTag;
    }
}

