/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.ErrorCodes;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import com.google.cloud.tools.jib.registry.RegistryErrorExceptionBuilder;
import com.google.cloud.tools.jib.registry.json.ErrorEntryTemplate;
import com.google.cloud.tools.jib.registry.json.ErrorResponseTemplate;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

class BlobChecker
implements RegistryEndpointProvider<BlobDescriptor> {
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final DescriptorDigest blobDigest;

    BlobChecker(RegistryEndpointRequestProperties registryEndpointRequestProperties, DescriptorDigest descriptorDigest) {
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.blobDigest = descriptorDigest;
    }

    @Override
    public BlobDescriptor handleResponse(Response response) throws RegistryErrorException {
        long l = response.getContentLength();
        if (l < 0L) {
            throw new RegistryErrorExceptionBuilder(this.getActionDescription()).addReason("Did not receive Content-Length header").build();
        }
        return new BlobDescriptor(l, this.blobDigest);
    }

    @Override
    @Nullable
    public BlobDescriptor handleHttpResponseException(HttpResponseException httpResponseException) throws RegistryErrorException, HttpResponseException {
        if (httpResponseException.getStatusCode() != 404) {
            throw httpResponseException;
        }
        String string = httpResponseException.getContent();
        if (string == null) {
            return null;
        }
        try {
            ErrorResponseTemplate errorResponseTemplate = JsonTemplateMapper.readJson(string, ErrorResponseTemplate.class);
            List<ErrorEntryTemplate> list = errorResponseTemplate.getErrors();
            if (list.size() == 1) {
                String string2 = list.get(0).getCode();
                if (string2 == null) {
                    throw httpResponseException;
                }
                ErrorCodes errorCodes = ErrorCodes.valueOf(string2);
                if (errorCodes.equals((Object)ErrorCodes.BLOB_UNKNOWN)) {
                    return null;
                }
            }
        }
        catch (IOException iOException) {
            throw new RegistryErrorExceptionBuilder(this.getActionDescription(), iOException).addReason("Failed to parse registry error response body").build();
        }
        throw httpResponseException;
    }

    @Override
    public URL getApiRoute(String string) throws MalformedURLException {
        return new URL(string + this.registryEndpointRequestProperties.getImageName() + "/blobs/" + this.blobDigest);
    }

    @Override
    @Nullable
    public BlobHttpContent getContent() {
        return null;
    }

    @Override
    public List<String> getAccept() {
        return Collections.emptyList();
    }

    @Override
    public String getHttpMethod() {
        return "HEAD";
    }

    @Override
    public String getActionDescription() {
        return "check BLOB exists for " + this.registryEndpointRequestProperties.getServerUrl() + "/" + this.registryEndpointRequestProperties.getImageName() + " with digest " + this.blobDigest;
    }
}

