/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.DigestOnlyLayer;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerCountMismatchException;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.ReferenceLayer;
import com.google.cloud.tools.jib.image.ReferenceNoDiffIdLayer;
import com.google.cloud.tools.jib.image.json.BadContainerConfigurationFormatException;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class JsonToImageTranslator {
    private static final Pattern portPattern = Pattern.compile("(\\d+)(?:/(tcp|udp))?");

    public static Image<Layer> toImage(V21ManifestTemplate v21ManifestTemplate) throws LayerPropertyNotFoundException {
        Image.Builder<DigestOnlyLayer> builder = Image.builder();
        for (DescriptorDigest descriptorDigest : v21ManifestTemplate.getLayerDigests()) {
            builder.addLayer(new DigestOnlyLayer(descriptorDigest));
        }
        return builder.build();
    }

    public static Image<Layer> toImage(BuildableManifestTemplate buildableManifestTemplate, ContainerConfigurationTemplate containerConfigurationTemplate) throws LayerCountMismatchException, LayerPropertyNotFoundException, BadContainerConfigurationFormatException {
        ArrayList<ReferenceNoDiffIdLayer> arrayList = new ArrayList<ReferenceNoDiffIdLayer>();
        for (BuildableManifestTemplate.ContentDescriptorTemplate object2 : buildableManifestTemplate.getLayers()) {
            if (object2.getDigest() == null) {
                throw new IllegalArgumentException("All layers in the manifest template must have digest set");
            }
            arrayList.add(new ReferenceNoDiffIdLayer(new BlobDescriptor(object2.getSize(), object2.getDigest())));
        }
        List<DescriptorDigest> list = containerConfigurationTemplate.getDiffIds();
        if (arrayList.size() != list.size()) {
            throw new LayerCountMismatchException("Mismatch between image manifest and container configuration");
        }
        Image.Builder<ReferenceLayer> builder = Image.builder();
        for (int dateTimeParseException = 0; dateTimeParseException < arrayList.size(); ++dateTimeParseException) {
            ReferenceNoDiffIdLayer referenceNoDiffIdLayer = (ReferenceNoDiffIdLayer)arrayList.get(dateTimeParseException);
            DescriptorDigest descriptorDigest = (DescriptorDigest)list.get(dateTimeParseException);
            builder.addLayer(new ReferenceLayer(referenceNoDiffIdLayer.getBlobDescriptor(), descriptorDigest));
        }
        if (containerConfigurationTemplate.getCreated() != null) {
            try {
                builder.setCreated(Instant.parse(containerConfigurationTemplate.getCreated()));
            }
            catch (DateTimeParseException dateTimeParseException) {
                throw new BadContainerConfigurationFormatException("Invalid image creation time: " + containerConfigurationTemplate.getCreated(), dateTimeParseException);
            }
        }
        if (containerConfigurationTemplate.getContainerEntrypoint() != null) {
            builder.setEntrypoint(containerConfigurationTemplate.getContainerEntrypoint());
        }
        if (containerConfigurationTemplate.getContainerCmd() != null) {
            builder.setJavaArguments(containerConfigurationTemplate.getContainerCmd());
        }
        if (containerConfigurationTemplate.getContainerExposedPorts() != null) {
            builder.setExposedPorts(JsonToImageTranslator.portMapToList(containerConfigurationTemplate.getContainerExposedPorts()));
        }
        if (containerConfigurationTemplate.getContainerEnvironment() != null) {
            for (String string : containerConfigurationTemplate.getContainerEnvironment()) {
                builder.addEnvironmentVariableDefinition(string);
            }
        }
        return builder.build();
    }

    @VisibleForTesting
    static ImmutableList<Port> portMapToList(@Nullable Map<String, Map<?, ?>> map) throws BadContainerConfigurationFormatException {
        if (map == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Map.Entry<String, Map<?, ?>> entry : map.entrySet()) {
            String string = entry.getKey();
            Matcher matcher = portPattern.matcher(string);
            if (!matcher.matches()) {
                throw new BadContainerConfigurationFormatException("Invalid port configuration: '" + string + "'.");
            }
            int n = Integer.parseInt(matcher.group(1));
            String string2 = matcher.group(2);
            builder.add((Object)new Port(n, Port.Protocol.getFromString(string2)));
        }
        return builder.build();
    }

    private JsonToImageTranslator() {
    }
}

