/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.image.ImageLayers;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class Image<T extends Layer> {
    @Nullable
    private final Instant created;
    private final ImageLayers<T> layers;
    @Nullable
    private final ImmutableList<String> environment;
    @Nullable
    private final ImmutableList<String> entrypoint;
    @Nullable
    private final ImmutableList<String> javaArguments;
    @Nullable
    private final ImmutableList<Port> exposedPorts;

    public static <T extends Layer> Builder<T> builder() {
        return new Builder();
    }

    private Image(@Nullable Instant instant, ImageLayers<T> imageLayers, @Nullable ImmutableList<String> immutableList, @Nullable ImmutableList<String> immutableList2, @Nullable ImmutableList<String> immutableList3, @Nullable ImmutableList<Port> immutableList4) {
        this.created = instant;
        this.layers = imageLayers;
        this.environment = immutableList;
        this.entrypoint = immutableList2;
        this.javaArguments = immutableList3;
        this.exposedPorts = immutableList4;
    }

    @Nullable
    public Instant getCreated() {
        return this.created;
    }

    @Nullable
    public ImmutableList<String> getEnvironment() {
        return this.environment;
    }

    @Nullable
    public ImmutableList<String> getEntrypoint() {
        return this.entrypoint;
    }

    @Nullable
    public ImmutableList<String> getJavaArguments() {
        return this.javaArguments;
    }

    @Nullable
    public ImmutableList<Port> getExposedPorts() {
        return this.exposedPorts;
    }

    public ImmutableList<T> getLayers() {
        return this.layers.getLayers();
    }

    public static class Builder<T extends Layer> {
        private final ImageLayers.Builder<T> imageLayersBuilder = ImageLayers.builder();
        private ImmutableList.Builder<String> environmentBuilder = ImmutableList.builder();
        @Nullable
        private Instant created;
        @Nullable
        private ImmutableList<String> entrypoint;
        @Nullable
        private ImmutableList<String> javaArguments;
        @Nullable
        private ImmutableList<Port> exposedPorts;

        public Builder<T> setCreated(Instant instant) {
            this.created = instant;
            return this;
        }

        public Builder<T> setEnvironment(@Nullable Map<String, String> map) {
            if (map == null) {
                this.environmentBuilder = ImmutableList.builder();
            } else {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.setEnvironmentVariable(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        public Builder<T> setEnvironmentVariable(String string, String string2) {
            this.environmentBuilder.add((Object)(string + "=" + string2));
            return this;
        }

        public Builder<T> addEnvironmentVariableDefinition(String string) {
            this.environmentBuilder.add((Object)string);
            return this;
        }

        public Builder<T> setEntrypoint(@Nullable List<String> list) {
            this.entrypoint = list == null ? null : ImmutableList.copyOf(list);
            return this;
        }

        public Builder<T> setJavaArguments(@Nullable List<String> list) {
            this.javaArguments = list == null ? null : ImmutableList.copyOf(list);
            return this;
        }

        public Builder<T> setExposedPorts(@Nullable ImmutableList<Port> immutableList) {
            this.exposedPorts = immutableList == null ? null : immutableList;
            return this;
        }

        public Builder<T> addLayer(T t) throws LayerPropertyNotFoundException {
            this.imageLayersBuilder.add(t);
            return this;
        }

        public Image<T> build() {
            return new Image(this.created, this.imageLayersBuilder.build(), this.environmentBuilder.build(), this.entrypoint, this.javaArguments, this.exposedPorts);
        }
    }
}

