/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.docker;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.tools.jib.filesystem.FileOperations;
import com.google.cloud.tools.jib.frontend.JavaEntrypointConstructor;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class DockerContextGenerator {
    private static final String DEPENDENCIES_LAYER_DIRECTORY = "libs";
    private static final String SNAPSHOT_DEPENDENCIES_LAYER_DIRECTORY = "snapshot-libs";
    private static final String RESOURCES_LAYER_DIRECTORY = "resources";
    private static final String CLASSES_LAYER_DIRECTORY = "classes";
    private static final String EXTRA_FILES_LAYER_DIRECTORY = "root";
    private final ImmutableList<CopyDirective> copyDirectives;
    @Nullable
    private String baseImage;
    private List<String> jvmFlags = Collections.emptyList();
    private String mainClass = "";
    private List<String> javaArguments = Collections.emptyList();
    private List<String> exposedPorts = Collections.emptyList();

    private static void addIfNotEmpty(ImmutableList.Builder<CopyDirective> builder, LayerEntry layerEntry, String string) {
        if (layerEntry.getSourceFiles().isEmpty()) {
            return;
        }
        builder.add((Object)new CopyDirective(layerEntry.getSourceFiles(), string, layerEntry.getExtractionPath()));
    }

    public DockerContextGenerator(LayerEntry layerEntry, LayerEntry layerEntry2, LayerEntry layerEntry3, LayerEntry layerEntry4, LayerEntry layerEntry5) {
        ImmutableList.Builder builder = ImmutableList.builder();
        DockerContextGenerator.addIfNotEmpty((ImmutableList.Builder<CopyDirective>)builder, layerEntry, DEPENDENCIES_LAYER_DIRECTORY);
        DockerContextGenerator.addIfNotEmpty((ImmutableList.Builder<CopyDirective>)builder, layerEntry2, SNAPSHOT_DEPENDENCIES_LAYER_DIRECTORY);
        DockerContextGenerator.addIfNotEmpty((ImmutableList.Builder<CopyDirective>)builder, layerEntry3, RESOURCES_LAYER_DIRECTORY);
        DockerContextGenerator.addIfNotEmpty((ImmutableList.Builder<CopyDirective>)builder, layerEntry4, CLASSES_LAYER_DIRECTORY);
        DockerContextGenerator.addIfNotEmpty((ImmutableList.Builder<CopyDirective>)builder, layerEntry5, EXTRA_FILES_LAYER_DIRECTORY);
        this.copyDirectives = builder.build();
    }

    public DockerContextGenerator setBaseImage(String string) {
        this.baseImage = string;
        return this;
    }

    public DockerContextGenerator setJvmFlags(List<String> list) {
        this.jvmFlags = list;
        return this;
    }

    public DockerContextGenerator setMainClass(String string) {
        this.mainClass = string;
        return this;
    }

    public DockerContextGenerator setJavaArguments(List<String> list) {
        this.javaArguments = list;
        return this;
    }

    public DockerContextGenerator setExposedPorts(List<String> list) {
        this.exposedPorts = list;
        return this;
    }

    public void generate(Path path) throws IOException {
        Preconditions.checkNotNull((Object)this.baseImage);
        try {
            Files.deleteIfExists(path);
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {
            MoreFiles.deleteDirectoryContents((Path)path, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
            Files.delete(path);
        }
        Files.createDirectory(path, new FileAttribute[0]);
        for (CopyDirective copyDirective : this.copyDirectives) {
            Path path2 = path.resolve(copyDirective.directoryInContext);
            Files.createDirectory(path2, new FileAttribute[0]);
            FileOperations.copy((ImmutableList<Path>)copyDirective.sourceFiles, path2);
        }
        Files.write(path.resolve("Dockerfile"), this.makeDockerfile().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @VisibleForTesting
    String makeDockerfile() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FROM ").append((String)Preconditions.checkNotNull((Object)this.baseImage)).append("\n");
        for (Object object : this.copyDirectives) {
            stringBuilder.append("\nCOPY ").append(((CopyDirective)object).directoryInContext).append(" ").append(((CopyDirective)object).extractionPath);
        }
        stringBuilder.append("\n");
        for (Object object : this.exposedPorts) {
            stringBuilder.append("\nEXPOSE ").append((String)object);
        }
        stringBuilder.append("\nENTRYPOINT ").append(objectMapper.writeValueAsString(JavaEntrypointConstructor.makeDefaultEntrypoint(this.jvmFlags, this.mainClass))).append("\nCMD ").append(objectMapper.writeValueAsString(this.javaArguments));
        return stringBuilder.toString();
    }

    private static class CopyDirective {
        private final ImmutableList<Path> sourceFiles;
        private final String directoryInContext;
        private final String extractionPath;

        private CopyDirective(ImmutableList<Path> immutableList, String string, String string2) {
            this.sourceFiles = immutableList;
            this.directoryInContext = string;
            this.extractionPath = string2;
        }
    }
}

