/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import java.util.Objects;
import javax.annotation.Nullable;

public class Port {
    private final int port;
    private final Protocol protocol;

    public Port(int n, Protocol protocol) {
        this.port = n;
        this.protocol = protocol;
    }

    public int getPort() {
        return this.port;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Port)) {
            return false;
        }
        Port port = (Port)object;
        return this.port == port.port && this.protocol == port.protocol;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.port, this.protocol});
    }

    public String toString() {
        return this.port + "/" + (Object)((Object)this.protocol);
    }

    public static enum Protocol {
        TCP("tcp"),
        UDP("udp");

        private final String stringRepresentation;

        private Protocol(String string2) {
            this.stringRepresentation = string2;
        }

        public String toString() {
            return this.stringRepresentation;
        }

        public static Protocol getFromString(@Nullable String string) {
            if (string == null) {
                return TCP;
            }
            return UDP.toString().equalsIgnoreCase(string) ? UDP : TCP;
        }
    }
}

