/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.util.List;

public class LayerConfiguration {
    private final ImmutableList<LayerEntry> layerEntries;
    private final String label;

    public static Builder builder() {
        return new Builder();
    }

    private LayerConfiguration(String string, ImmutableList<LayerEntry> immutableList) {
        this.label = string;
        this.layerEntries = immutableList;
    }

    public String getLabel() {
        return this.label;
    }

    public ImmutableList<LayerEntry> getLayerEntries() {
        return this.layerEntries;
    }

    public static class Builder {
        private final ImmutableList.Builder<LayerEntry> layerEntries = ImmutableList.builder();
        private String label = "";

        private Builder() {
        }

        public Builder setLabel(String string) {
            this.label = string;
            return this;
        }

        public Builder addEntry(List<Path> list, String string) {
            Preconditions.checkArgument((!list.contains(null) ? 1 : 0) != 0);
            this.layerEntries.add((Object)new LayerEntry((ImmutableList<Path>)ImmutableList.copyOf(list), string));
            return this;
        }

        public LayerConfiguration build() {
            return new LayerConfiguration(this.label, this.layerEntries.build());
        }
    }
}

