/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;

class LayerMetadata {
    private ImmutableList<LayerMetadataEntry> entries;
    private final FileTime lastModifiedTime;

    static LayerMetadata from(ImmutableList<LayerEntry> immutableList, FileTime fileTime) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)immutableList.size());
        for (LayerEntry layerEntry : immutableList) {
            ImmutableList<Path> immutableList2 = layerEntry.getSourceFiles();
            ImmutableList.Builder builder2 = ImmutableList.builderWithExpectedSize((int)immutableList2.size());
            for (Path path : immutableList2) {
                builder2.add((Object)path.toString());
            }
            builder.add((Object)new LayerMetadataEntry(builder2.build(), layerEntry.getExtractionPath()));
        }
        return new LayerMetadata((ImmutableList<LayerMetadataEntry>)builder.build(), fileTime);
    }

    LayerMetadata(ImmutableList<LayerMetadataEntry> immutableList, FileTime fileTime) {
        this.entries = immutableList;
        this.lastModifiedTime = fileTime;
    }

    ImmutableList<LayerMetadataEntry> getEntries() {
        return this.entries;
    }

    FileTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @VisibleForTesting
    void setEntry(ImmutableList<String> immutableList, String string) {
        this.entries = ImmutableList.of((Object)new LayerMetadataEntry(immutableList, string));
    }

    static class LayerMetadataEntry {
        private ImmutableList<String> sourceFilesStrings;
        private String extractionPath;

        ImmutableList<String> getSourceFilesStrings() {
            return this.sourceFilesStrings;
        }

        String getExtractionPath() {
            return this.extractionPath;
        }

        private LayerMetadataEntry(ImmutableList<String> immutableList, String string) {
            this.sourceFilesStrings = immutableList;
            this.extractionPath = string;
        }
    }
}

