/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheFiles;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.cache.LayerMetadata;
import com.google.cloud.tools.jib.hash.CountingDigestOutputStream;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.ReproducibleLayerBuilder;
import com.google.cloud.tools.jib.image.UnwrittenLayer;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CacheWriter {
    private final Cache cache;

    public CacheWriter(Cache cache) {
        this.cache = cache;
    }

    public CachedLayerWithMetadata writeLayer(ReproducibleLayerBuilder reproducibleLayerBuilder) throws IOException {
        UnwrittenLayer unwrittenLayer = reproducibleLayerBuilder.build();
        Path path = Files.createTempFile(this.cache.getCacheDirectory(), null, null, new FileAttribute[0]);
        path.toFile().deleteOnExit();
        try (CountingDigestOutputStream countingDigestOutputStream = new CountingDigestOutputStream(new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0])));){
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(countingDigestOutputStream);
            DescriptorDigest descriptorDigest = unwrittenLayer.getBlob().writeTo(gZIPOutputStream).getDigest();
            gZIPOutputStream.close();
            BlobDescriptor blobDescriptor = countingDigestOutputStream.toBlobDescriptor();
            Path path2 = this.getLayerFile(blobDescriptor.getDigest());
            Files.move(path, path2, StandardCopyOption.REPLACE_EXISTING);
            CachedLayer cachedLayer = new CachedLayer(path2, blobDescriptor, descriptorDigest);
            LayerMetadata layerMetadata = LayerMetadata.from(reproducibleLayerBuilder.getLayerEntries(), FileTime.from(Instant.now()));
            CachedLayerWithMetadata cachedLayerWithMetadata = new CachedLayerWithMetadata(cachedLayer, layerMetadata);
            return cachedLayerWithMetadata;
        }
    }

    public CountingOutputStream getLayerOutputStream(DescriptorDigest descriptorDigest) throws IOException {
        Path path = this.getLayerFile(descriptorDigest);
        return new CountingOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0])));
    }

    public CachedLayer getCachedLayer(long l, DescriptorDigest descriptorDigest) throws IOException {
        Path path = this.getLayerFile(descriptorDigest);
        return new CachedLayer(path, new BlobDescriptor(l, descriptorDigest), this.getDiffId(path));
    }

    private Path getLayerFile(DescriptorDigest descriptorDigest) {
        return CacheFiles.getLayerFile(this.cache.getCacheDirectory(), descriptorDigest);
    }

    private DescriptorDigest getDiffId(Path path) throws IOException {
        CountingDigestOutputStream countingDigestOutputStream = new CountingDigestOutputStream(ByteStreams.nullOutputStream());
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
             GZIPInputStream gZIPInputStream = new GZIPInputStream(bufferedInputStream);){
            ByteStreams.copy((InputStream)gZIPInputStream, (OutputStream)countingDigestOutputStream);
        }
        return countingDigestOutputStream.toBlobDescriptor().getDigest();
    }
}

