/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.cache.CacheFiles;
import com.google.cloud.tools.jib.cache.CacheMetadata;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.cache.LayerMetadata;
import com.google.cloud.tools.jib.cache.json.CacheMetadataLayerObjectTemplate;
import com.google.cloud.tools.jib.cache.json.CacheMetadataLayerPropertiesObjectTemplate;
import com.google.cloud.tools.jib.cache.json.CacheMetadataTemplate;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

public class CacheMetadataTranslator {
    static CacheMetadata fromTemplate(CacheMetadataTemplate cacheMetadataTemplate, Path path) throws CacheMetadataCorruptedException {
        CacheMetadata.Builder builder = CacheMetadata.builder();
        for (CacheMetadataLayerObjectTemplate cacheMetadataLayerObjectTemplate : cacheMetadataTemplate.getLayers()) {
            Object object;
            if (cacheMetadataLayerObjectTemplate.getDigest() == null || cacheMetadataLayerObjectTemplate.getDiffId() == null) {
                throw new CacheMetadataCorruptedException("Cannot translate cache metadata layer without a digest or diffId");
            }
            Path path2 = CacheFiles.getLayerFile(path, cacheMetadataLayerObjectTemplate.getDigest());
            CacheMetadataLayerPropertiesObjectTemplate cacheMetadataLayerPropertiesObjectTemplate = cacheMetadataLayerObjectTemplate.getProperties();
            LayerMetadata layerMetadata = null;
            if (cacheMetadataLayerPropertiesObjectTemplate != null) {
                object = ImmutableList.builderWithExpectedSize((int)cacheMetadataLayerPropertiesObjectTemplate.getLayerEntries().size());
                for (CacheMetadataLayerPropertiesObjectTemplate.LayerEntryTemplate layerEntryTemplate : cacheMetadataLayerPropertiesObjectTemplate.getLayerEntries()) {
                    if (layerEntryTemplate.getSourceFiles() == null || layerEntryTemplate.getExtractionPath() == null) {
                        throw new CacheMetadataCorruptedException("Cannot translate cache metadata layer entry without source files or extraction path");
                    }
                    object.add((Object)new LayerEntry((ImmutableList<Path>)((ImmutableList)layerEntryTemplate.getSourceFiles().stream().map(string -> Paths.get(string, new String[0])).collect(ImmutableList.toImmutableList())), layerEntryTemplate.getExtractionPath()));
                }
                layerMetadata = LayerMetadata.from((ImmutableList<LayerEntry>)object.build(), cacheMetadataLayerPropertiesObjectTemplate.getLastModifiedTime());
            }
            object = new CachedLayer(path2, new BlobDescriptor(cacheMetadataLayerObjectTemplate.getSize(), cacheMetadataLayerObjectTemplate.getDigest()), cacheMetadataLayerObjectTemplate.getDiffId());
            CachedLayerWithMetadata cachedLayerWithMetadata = new CachedLayerWithMetadata((CachedLayer)object, layerMetadata);
            builder.addLayer(cachedLayerWithMetadata);
        }
        return builder.build();
    }

    static CacheMetadataTemplate toTemplate(CacheMetadata cacheMetadata) {
        CacheMetadataTemplate cacheMetadataTemplate = new CacheMetadataTemplate();
        for (CachedLayerWithMetadata cachedLayerWithMetadata : cacheMetadata.getLayers()) {
            CacheMetadataLayerObjectTemplate cacheMetadataLayerObjectTemplate = new CacheMetadataLayerObjectTemplate().setSize(cachedLayerWithMetadata.getBlobDescriptor().getSize()).setDigest(cachedLayerWithMetadata.getBlobDescriptor().getDigest()).setDiffId(cachedLayerWithMetadata.getDiffId());
            if (cachedLayerWithMetadata.getMetadata() != null) {
                List<CacheMetadataLayerPropertiesObjectTemplate.LayerEntryTemplate> list = cachedLayerWithMetadata.getMetadata().getEntries().stream().map(layerMetadataEntry -> new CacheMetadataLayerPropertiesObjectTemplate.LayerEntryTemplate((List<String>)layerMetadataEntry.getSourceFilesStrings(), layerMetadataEntry.getExtractionPath())).collect(Collectors.toList());
                cacheMetadataLayerObjectTemplate.setProperties(new CacheMetadataLayerPropertiesObjectTemplate().setLayerEntries(list).setLastModifiedTime(cachedLayerWithMetadata.getMetadata().getLastModifiedTime()));
            }
            cacheMetadataTemplate.addLayer(cacheMetadataLayerObjectTemplate);
        }
        return cacheMetadataTemplate;
    }
}

