/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.cache.LayerMetadata;
import com.google.cloud.tools.jib.image.ImageLayers;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;

class CacheMetadata {
    private final ImageLayers<CachedLayerWithMetadata> layers;

    static Builder builder() {
        return new Builder();
    }

    private CacheMetadata(ImageLayers<CachedLayerWithMetadata> imageLayers) {
        this.layers = imageLayers;
    }

    ImageLayers<CachedLayerWithMetadata> getLayers() {
        return this.layers;
    }

    LayerFilter filterLayers() {
        return new LayerFilter(this.layers);
    }

    Builder newAppendingBuilder() {
        return new Builder(this.layers);
    }

    static class LayerFilter {
        private final ImageLayers<CachedLayerWithMetadata> layers;
        @Nullable
        private ImmutableList<LayerEntry> layerEntries;

        @VisibleForTesting
        static boolean doLayerEntriesMatchMetadataEntries(ImmutableList<LayerEntry> immutableList, ImmutableList<LayerMetadata.LayerMetadataEntry> immutableList2) {
            if (immutableList.size() != immutableList2.size()) {
                return false;
            }
            return LayerFilter.pairwiseCompareAllPass(immutableList, immutableList2, (layerEntry, layerMetadataEntry) -> {
                if (!layerEntry.getExtractionPath().equals(layerMetadataEntry.getExtractionPath())) {
                    return false;
                }
                if (layerEntry.getSourceFiles().size() != layerMetadataEntry.getSourceFilesStrings().size()) {
                    return false;
                }
                return LayerFilter.pairwiseCompareAllPass(layerEntry.getSourceFiles(), layerMetadataEntry.getSourceFilesStrings(), (path, string) -> path.equals(Paths.get(string, new String[0])));
            });
        }

        private static <A, B> boolean pairwiseCompareAllPass(List<A> list, List<B> list2, BiPredicate<A, B> biPredicate) {
            return Streams.zip(list.stream(), list2.stream(), biPredicate::test).allMatch(Predicate.isEqual(true));
        }

        private LayerFilter(ImageLayers<CachedLayerWithMetadata> imageLayers) {
            this.layers = imageLayers;
        }

        LayerFilter byLayerEntries(ImmutableList<LayerEntry> immutableList) {
            this.layerEntries = immutableList;
            return this;
        }

        ImageLayers<CachedLayerWithMetadata> filter() throws CacheMetadataCorruptedException {
            try {
                ImageLayers.Builder builder = ImageLayers.builder();
                for (CachedLayerWithMetadata cachedLayerWithMetadata : this.layers) {
                    if (this.layerEntries != null && (cachedLayerWithMetadata.getMetadata() == null || !LayerFilter.doLayerEntriesMatchMetadataEntries(this.layerEntries, cachedLayerWithMetadata.getMetadata().getEntries()))) continue;
                    builder.add(cachedLayerWithMetadata);
                }
                return builder.build();
            }
            catch (LayerPropertyNotFoundException layerPropertyNotFoundException) {
                throw new CacheMetadataCorruptedException(layerPropertyNotFoundException);
            }
        }
    }

    static class Builder {
        private final ImageLayers.Builder<CachedLayerWithMetadata> layersBuilder = ImageLayers.builder();

        private Builder(ImageLayers<CachedLayerWithMetadata> imageLayers) {
            this.layersBuilder.addAll(imageLayers);
        }

        private Builder() {
        }

        Builder addLayer(CachedLayerWithMetadata cachedLayerWithMetadata) {
            this.layersBuilder.add(cachedLayerWithMetadata);
            return this;
        }

        CacheMetadata build() {
            return new CacheMetadata(this.layersBuilder.build());
        }
    }
}

