/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.cache.CacheMetadata;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CacheMetadataTranslator;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.cache.json.CacheMetadataTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public class Cache
implements Closeable {
    private final Path cacheDirectory;
    private final CacheMetadata cacheMetadata;
    private final CacheMetadata.Builder cacheMetadataBuilder;

    public static Cache init(Path path) throws NotDirectoryException, CacheMetadataCorruptedException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new NotDirectoryException("The cache can only write to a directory");
        }
        CacheMetadata cacheMetadata = Cache.loadCacheMetadata(path);
        return new Cache(path, cacheMetadata);
    }

    private static CacheMetadata loadCacheMetadata(Path path) throws CacheMetadataCorruptedException {
        Path path2 = path.resolve("metadata-v2.json");
        if (!Files.exists(path2, new LinkOption[0])) {
            return CacheMetadata.builder().build();
        }
        try {
            CacheMetadataTemplate cacheMetadataTemplate = JsonTemplateMapper.readJsonFromFile(path2, CacheMetadataTemplate.class);
            return CacheMetadataTranslator.fromTemplate(cacheMetadataTemplate, path);
        }
        catch (IOException iOException) {
            throw new CacheMetadataCorruptedException(iOException);
        }
    }

    private Cache(Path path, CacheMetadata cacheMetadata) {
        this.cacheDirectory = path;
        this.cacheMetadata = cacheMetadata;
        this.cacheMetadataBuilder = cacheMetadata.newAppendingBuilder();
    }

    @Override
    public void close() throws IOException {
        this.saveCacheMetadata(this.cacheDirectory);
    }

    public void addCachedLayersToMetadata(List<CachedLayer> list) {
        for (CachedLayer cachedLayer : list) {
            this.cacheMetadataBuilder.addLayer(new CachedLayerWithMetadata(cachedLayer, null));
        }
    }

    public void addCachedLayersWithMetadataToMetadata(List<CachedLayerWithMetadata> list) {
        for (CachedLayerWithMetadata cachedLayerWithMetadata : list) {
            this.cacheMetadataBuilder.addLayer(cachedLayerWithMetadata);
        }
    }

    @VisibleForTesting
    Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    @VisibleForTesting
    CacheMetadata getMetadata() {
        return this.cacheMetadata;
    }

    @VisibleForTesting
    CacheMetadata getUpdatedMetadata() {
        return this.cacheMetadataBuilder.build();
    }

    private void saveCacheMetadata(Path path) throws IOException {
        Path path2 = path.resolve("metadata-v2.json");
        CacheMetadataTemplate cacheMetadataTemplate = CacheMetadataTranslator.toTemplate(this.cacheMetadataBuilder.build());
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(Files.newOutputStream(path2, new OpenOption[0]));){
            JsonTemplateMapper.toBlob(cacheMetadataTemplate).writeTo(bufferedOutputStream);
        }
    }
}

