/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.AsyncSteps;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.builder.steps.AuthenticatePushStep;
import com.google.cloud.tools.jib.builder.steps.BuildAndCacheApplicationLayerStep;
import com.google.cloud.tools.jib.builder.steps.BuildImageStep;
import com.google.cloud.tools.jib.builder.steps.FinalizingStep;
import com.google.cloud.tools.jib.builder.steps.LoadDockerStep;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayerStep;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayersStep;
import com.google.cloud.tools.jib.builder.steps.PullBaseImageStep;
import com.google.cloud.tools.jib.builder.steps.PushContainerConfigurationStep;
import com.google.cloud.tools.jib.builder.steps.PushImageStep;
import com.google.cloud.tools.jib.builder.steps.PushLayersStep;
import com.google.cloud.tools.jib.builder.steps.RetrieveRegistryCredentialsStep;
import com.google.cloud.tools.jib.builder.steps.WriteTarFileStep;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;

public class StepsRunner {
    private final ListeningExecutorService listeningExecutorService;
    private final BuildConfiguration buildConfiguration;
    private final Cache baseLayersCache;
    private final Cache applicationLayersCache;
    @Nullable
    private RetrieveRegistryCredentialsStep retrieveTargetRegistryCredentialsStep;
    @Nullable
    private AuthenticatePushStep authenticatePushStep;
    @Nullable
    private PullBaseImageStep pullBaseImageStep;
    @Nullable
    private PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep;
    @Nullable
    private ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps;
    @Nullable
    private PushLayersStep pushBaseImageLayersStep;
    @Nullable
    private PushLayersStep pushApplicationLayersStep;
    @Nullable
    private BuildImageStep buildImageStep;
    @Nullable
    private PushContainerConfigurationStep pushContainerConfigurationStep;
    @Nullable
    private PushImageStep pushImageStep;
    @Nullable
    private LoadDockerStep loadDockerStep;
    @Nullable
    private WriteTarFileStep writeTarFileStep;

    public StepsRunner(BuildConfiguration buildConfiguration, Cache cache, Cache cache2) {
        this.buildConfiguration = buildConfiguration;
        this.baseLayersCache = cache;
        this.applicationLayersCache = cache2;
        Object object = Boolean.getBoolean("jibSerialized") ? MoreExecutors.newDirectExecutorService() : Executors.newCachedThreadPool();
        this.listeningExecutorService = MoreExecutors.listeningDecorator((ExecutorService)object);
    }

    public StepsRunner runRetrieveTargetRegistryCredentialsStep() {
        this.retrieveTargetRegistryCredentialsStep = RetrieveRegistryCredentialsStep.forTargetImage(this.listeningExecutorService, this.buildConfiguration);
        return this;
    }

    public StepsRunner runAuthenticatePushStep() {
        this.authenticatePushStep = new AuthenticatePushStep(this.listeningExecutorService, this.buildConfiguration, (RetrieveRegistryCredentialsStep)Preconditions.checkNotNull((Object)this.retrieveTargetRegistryCredentialsStep));
        return this;
    }

    public StepsRunner runPullBaseImageStep() {
        this.pullBaseImageStep = new PullBaseImageStep(this.listeningExecutorService, this.buildConfiguration);
        return this;
    }

    public StepsRunner runPullAndCacheBaseImageLayersStep() {
        this.pullAndCacheBaseImageLayersStep = new PullAndCacheBaseImageLayersStep(this.listeningExecutorService, this.buildConfiguration, this.baseLayersCache, (PullBaseImageStep)Preconditions.checkNotNull((Object)this.pullBaseImageStep));
        return this;
    }

    public StepsRunner runPushBaseImageLayersStep() {
        this.pushBaseImageLayersStep = new PushLayersStep(this.listeningExecutorService, this.buildConfiguration, (AuthenticatePushStep)Preconditions.checkNotNull((Object)this.authenticatePushStep), (AsyncStep)Preconditions.checkNotNull((Object)this.pullAndCacheBaseImageLayersStep));
        return this;
    }

    public StepsRunner runBuildAndCacheApplicationLayerSteps() {
        this.buildAndCacheApplicationLayerSteps = BuildAndCacheApplicationLayerStep.makeList(this.listeningExecutorService, this.buildConfiguration, this.applicationLayersCache);
        return this;
    }

    public StepsRunner runBuildImageStep() {
        this.buildImageStep = new BuildImageStep(this.listeningExecutorService, this.buildConfiguration, (PullAndCacheBaseImageLayersStep)Preconditions.checkNotNull((Object)this.pullAndCacheBaseImageLayersStep), (ImmutableList<BuildAndCacheApplicationLayerStep>)((ImmutableList)Preconditions.checkNotNull(this.buildAndCacheApplicationLayerSteps)));
        return this;
    }

    public StepsRunner runPushContainerConfigurationStep() {
        this.pushContainerConfigurationStep = new PushContainerConfigurationStep(this.listeningExecutorService, this.buildConfiguration, (AuthenticatePushStep)Preconditions.checkNotNull((Object)this.authenticatePushStep), (BuildImageStep)Preconditions.checkNotNull((Object)this.buildImageStep));
        return this;
    }

    public StepsRunner runPushApplicationLayersStep() {
        this.pushApplicationLayersStep = new PushLayersStep(this.listeningExecutorService, this.buildConfiguration, (AuthenticatePushStep)Preconditions.checkNotNull((Object)this.authenticatePushStep), AsyncSteps.immediate(Preconditions.checkNotNull(this.buildAndCacheApplicationLayerSteps)));
        return this;
    }

    public StepsRunner runFinalizingPushStep() {
        new FinalizingStep(this.listeningExecutorService, this.buildConfiguration, Arrays.asList((AsyncStep)Preconditions.checkNotNull((Object)this.pushBaseImageLayersStep), (AsyncStep)Preconditions.checkNotNull((Object)this.pushApplicationLayersStep)), Collections.emptyList());
        return this;
    }

    public StepsRunner runFinalizingBuildStep() {
        new FinalizingStep(this.listeningExecutorService, this.buildConfiguration, Collections.singletonList(Preconditions.checkNotNull((Object)this.pullAndCacheBaseImageLayersStep)), (List)Preconditions.checkNotNull(this.buildAndCacheApplicationLayerSteps));
        return this;
    }

    public StepsRunner runPushImageStep() {
        this.pushImageStep = new PushImageStep(this.listeningExecutorService, this.buildConfiguration, (AuthenticatePushStep)Preconditions.checkNotNull((Object)this.authenticatePushStep), (PushLayersStep)Preconditions.checkNotNull((Object)this.pushBaseImageLayersStep), (PushLayersStep)Preconditions.checkNotNull((Object)this.pushApplicationLayersStep), (PushContainerConfigurationStep)Preconditions.checkNotNull((Object)this.pushContainerConfigurationStep), (BuildImageStep)Preconditions.checkNotNull((Object)this.buildImageStep));
        return this;
    }

    public StepsRunner runLoadDockerStep() {
        this.loadDockerStep = new LoadDockerStep(this.listeningExecutorService, this.buildConfiguration, (PullAndCacheBaseImageLayersStep)Preconditions.checkNotNull((Object)this.pullAndCacheBaseImageLayersStep), (ImmutableList<BuildAndCacheApplicationLayerStep>)((ImmutableList)Preconditions.checkNotNull(this.buildAndCacheApplicationLayerSteps)), (BuildImageStep)Preconditions.checkNotNull((Object)this.buildImageStep));
        return this;
    }

    public StepsRunner runWriteTarFileStep(Path path) {
        this.writeTarFileStep = new WriteTarFileStep(this.listeningExecutorService, path, this.buildConfiguration, (PullAndCacheBaseImageLayersStep)Preconditions.checkNotNull((Object)this.pullAndCacheBaseImageLayersStep), (ImmutableList<BuildAndCacheApplicationLayerStep>)((ImmutableList)Preconditions.checkNotNull(this.buildAndCacheApplicationLayerSteps)), (BuildImageStep)Preconditions.checkNotNull((Object)this.buildImageStep));
        return this;
    }

    public void waitOnPushImageStep() throws ExecutionException, InterruptedException {
        ((PushImageStep)Preconditions.checkNotNull((Object)this.pushImageStep)).getFuture().get();
    }

    public void waitOnLoadDockerStep() throws ExecutionException, InterruptedException {
        ((LoadDockerStep)Preconditions.checkNotNull((Object)this.loadDockerStep)).getFuture().get();
    }

    public void waitOnWriteTarFileStep() throws ExecutionException, InterruptedException {
        ((WriteTarFileStep)Preconditions.checkNotNull((Object)this.writeTarFileStep)).getFuture().get();
    }

    public List<CachedLayer> getCachedBaseImageLayers() throws ExecutionException {
        ImmutableList immutableList = (ImmutableList)NonBlockingSteps.get((AsyncStep)Preconditions.checkNotNull((Object)this.pullAndCacheBaseImageLayersStep));
        ArrayList<CachedLayer> arrayList = new ArrayList<CachedLayer>(immutableList.size());
        for (PullAndCacheBaseImageLayerStep pullAndCacheBaseImageLayerStep : immutableList) {
            arrayList.add(NonBlockingSteps.get(pullAndCacheBaseImageLayerStep));
        }
        return arrayList;
    }

    public List<CachedLayerWithMetadata> getCachedApplicationLayers() throws ExecutionException {
        ArrayList<CachedLayerWithMetadata> arrayList = new ArrayList<CachedLayerWithMetadata>(((ImmutableList)Preconditions.checkNotNull(this.buildAndCacheApplicationLayerSteps)).size());
        for (BuildAndCacheApplicationLayerStep buildAndCacheApplicationLayerStep : this.buildAndCacheApplicationLayerSteps) {
            arrayList.add(NonBlockingSteps.get(buildAndCacheApplicationLayerStep));
        }
        return arrayList;
    }
}

