/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.registry.credentials.DockerConfigCredentialRetriever;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelperFactory;
import com.google.cloud.tools.jib.registry.credentials.NonexistentDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.NonexistentServerUrlDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class RetrieveRegistryCredentialsStep
implements AsyncStep<Authorization>,
Callable<Authorization> {
    private static final String DESCRIPTION = "Retrieving registry credentials for %s";
    private static final ImmutableMap<String, String> COMMON_CREDENTIAL_HELPERS = ImmutableMap.of((Object)"gcr.io", (Object)"gcr", (Object)"amazonaws.com", (Object)"ecr-login");
    private final BuildLogger buildLogger;
    private final String registry;
    @Nullable
    private final String credentialHelperSuffix;
    @Nullable
    private final RegistryCredentials knownRegistryCredentials;
    private final DockerCredentialHelperFactory dockerCredentialHelperFactory;
    private final DockerConfigCredentialRetriever dockerConfigCredentialRetriever;
    private final ListenableFuture<Authorization> listenableFuture;

    static RetrieveRegistryCredentialsStep forBaseImage(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration) {
        return new RetrieveRegistryCredentialsStep(listeningExecutorService, buildConfiguration.getBuildLogger(), buildConfiguration.getBaseImageRegistry(), buildConfiguration.getBaseImageCredentialHelperName(), buildConfiguration.getKnownBaseRegistryCredentials());
    }

    static RetrieveRegistryCredentialsStep forTargetImage(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration) {
        return new RetrieveRegistryCredentialsStep(listeningExecutorService, buildConfiguration.getBuildLogger(), buildConfiguration.getTargetImageRegistry(), buildConfiguration.getTargetImageCredentialHelperName(), buildConfiguration.getKnownTargetRegistryCredentials());
    }

    @VisibleForTesting
    RetrieveRegistryCredentialsStep(ListeningExecutorService listeningExecutorService, BuildLogger buildLogger, String string, @Nullable String string2, @Nullable RegistryCredentials registryCredentials, DockerCredentialHelperFactory dockerCredentialHelperFactory, DockerConfigCredentialRetriever dockerConfigCredentialRetriever) {
        this.buildLogger = buildLogger;
        this.registry = string;
        this.credentialHelperSuffix = string2;
        this.knownRegistryCredentials = registryCredentials;
        this.dockerCredentialHelperFactory = dockerCredentialHelperFactory;
        this.dockerConfigCredentialRetriever = dockerConfigCredentialRetriever;
        this.listenableFuture = listeningExecutorService.submit((Callable)this);
    }

    private RetrieveRegistryCredentialsStep(ListeningExecutorService listeningExecutorService, BuildLogger buildLogger, String string, @Nullable String string2, @Nullable RegistryCredentials registryCredentials) {
        this(listeningExecutorService, buildLogger, string, string2, registryCredentials, new DockerCredentialHelperFactory(), new DockerConfigCredentialRetriever(string));
    }

    @Override
    public ListenableFuture<Authorization> getFuture() {
        return this.listenableFuture;
    }

    @Override
    @Nullable
    public Authorization call() throws IOException, NonexistentDockerCredentialHelperException {
        this.buildLogger.lifecycle(String.format(DESCRIPTION, this.registry) + "...");
        try (Timer timer = new Timer(this.buildLogger, String.format(DESCRIPTION, this.registry));){
            Authorization authorization;
            if (this.credentialHelperSuffix != null && (authorization = this.retrieveFromCredentialHelper(this.credentialHelperSuffix)) != null) {
                Authorization authorization2 = authorization;
                return authorization2;
            }
            if (this.knownRegistryCredentials != null) {
                this.logGotCredentialsFrom(this.knownRegistryCredentials.getCredentialSource());
                authorization = this.knownRegistryCredentials.getAuthorization();
                return authorization;
            }
            for (Object object : COMMON_CREDENTIAL_HELPERS.keySet()) {
                if (!this.registry.endsWith((String)object)) continue;
                try {
                    String string = (String)COMMON_CREDENTIAL_HELPERS.get(object);
                    if (string == null) {
                        throw new IllegalStateException("No COMMON_CREDENTIAL_HELPERS should be null");
                    }
                    Authorization authorization3 = this.retrieveFromCredentialHelper(string);
                    if (authorization3 == null) continue;
                    Authorization authorization4 = authorization3;
                    return authorization4;
                }
                catch (NonexistentDockerCredentialHelperException nonexistentDockerCredentialHelperException) {
                    if (nonexistentDockerCredentialHelperException.getMessage() == null) continue;
                    this.buildLogger.warn(nonexistentDockerCredentialHelperException.getMessage());
                }
            }
            try {
                authorization = this.dockerConfigCredentialRetriever.retrieve();
                if (authorization != null) {
                    Object object;
                    this.buildLogger.info("Using credentials from Docker config for " + this.registry);
                    object = authorization;
                    return object;
                }
            }
            catch (IOException iOException) {
                this.buildLogger.info("Unable to parse Docker config");
            }
            this.buildLogger.info("No credentials could be retrieved for registry " + this.registry);
            authorization = null;
            return authorization;
        }
    }

    @Nullable
    @VisibleForTesting
    Authorization retrieveFromCredentialHelper(String string) throws NonexistentDockerCredentialHelperException, IOException {
        this.buildLogger.info("Checking credentials from docker-credential-" + string);
        try {
            Authorization authorization = this.dockerCredentialHelperFactory.newDockerCredentialHelper(this.registry, string).retrieve();
            this.logGotCredentialsFrom("docker-credential-" + string);
            return authorization;
        }
        catch (NonexistentServerUrlDockerCredentialHelperException nonexistentServerUrlDockerCredentialHelperException) {
            this.buildLogger.info("No credentials for " + this.registry + " in docker-credential-" + string);
            return null;
        }
    }

    private void logGotCredentialsFrom(String string) {
        this.buildLogger.info("Using " + string + " for " + this.registry);
    }
}

