/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.builder.steps.RetrieveRegistryCredentialsStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

class AuthenticatePushStep
implements AsyncStep<Authorization>,
Callable<Authorization> {
    private static final String DESCRIPTION = "Authenticating with push to %s";
    private final BuildConfiguration buildConfiguration;
    private final RetrieveRegistryCredentialsStep retrieveTargetRegistryCredentialsStep;
    private final ListenableFuture<Authorization> listenableFuture;

    AuthenticatePushStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, RetrieveRegistryCredentialsStep retrieveRegistryCredentialsStep) {
        this.buildConfiguration = buildConfiguration;
        this.retrieveTargetRegistryCredentialsStep = retrieveRegistryCredentialsStep;
        this.listenableFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{retrieveRegistryCredentialsStep.getFuture()}).call((Callable)this, (Executor)listeningExecutorService);
    }

    @Override
    public ListenableFuture<Authorization> getFuture() {
        return this.listenableFuture;
    }

    @Override
    @Nullable
    public Authorization call() throws ExecutionException, RegistryAuthenticationFailedException, IOException, RegistryException {
        try (Timer timer = new Timer(this.buildConfiguration.getBuildLogger(), String.format(DESCRIPTION, this.buildConfiguration.getTargetImageRegistry()));){
            Authorization authorization = NonBlockingSteps.get(this.retrieveTargetRegistryCredentialsStep);
            RegistryAuthenticator registryAuthenticator = RegistryAuthenticator.initializer(this.buildConfiguration.getTargetImageRegistry(), this.buildConfiguration.getTargetImageRepository()).setAllowInsecureRegistries(this.buildConfiguration.getAllowInsecureRegistries()).initialize();
            if (registryAuthenticator == null) {
                Authorization authorization2 = authorization;
                return authorization2;
            }
            Authorization authorization3 = registryAuthenticator.setAuthorization(authorization).authenticatePush();
            return authorization3;
        }
    }
}

