/*
 * Decompiled with CFR 0.152.
 */
package de.gccc.jib;

import de.gccc.jib.Stripper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.X5455_ExtendedTimestamp;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipFile;

public final class ZipStripper
implements Stripper {
    private static final long DEFAULT_ZIP_TIMESTAMP = LocalDateTime.of(2000, 1, 1, 0, 0, 0, 0).atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli();
    private static final Comparator<String> MANIFEST_FILE_SORT_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            if ("META-INF/MANIFEST.MF".equals(string)) {
                return -1;
            }
            if ("META-INF/MANIFEST.MF".equals(string2)) {
                return 1;
            }
            if ("META-INF/".equals(string)) {
                return -1;
            }
            if ("META-INF/".equals(string2)) {
                return 1;
            }
            return string.compareTo(string2);
        }
    };
    private final Map<String, Stripper> subFilters = new HashMap<String, Stripper>();
    private final long zipTimestamp;

    public ZipStripper() {
        this.zipTimestamp = DEFAULT_ZIP_TIMESTAMP;
    }

    public ZipStripper(LocalDateTime localDateTime) {
        this.zipTimestamp = localDateTime.atZone(ZoneOffset.systemDefault()).toInstant().toEpochMilli();
    }

    public ZipStripper addFileStripper(String string, Stripper stripper) {
        this.subFilters.put(string, stripper);
        return this;
    }

    @Override
    public void strip(File file, File file2) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);
             ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream(file2);){
            List<String> list = this.sortEntriesByName(zipFile.getEntries());
            for (String string : list) {
                ZipArchiveEntry zipArchiveEntry = zipFile.getEntry(string);
                ZipArchiveEntry zipArchiveEntry2 = this.filterZipEntry(zipArchiveEntry);
                Stripper stripper = this.getSubFilter(string);
                if (stripper != null) {
                    File file3 = File.createTempFile("tmp", null);
                    file3.deleteOnExit();
                    Files.copy(zipFile.getInputStream(zipArchiveEntry), file3.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    File file4 = File.createTempFile("tmp", null);
                    file4.deleteOnExit();
                    stripper.strip(file3, file4);
                    byte[] byArray = Files.readAllBytes(file4.toPath());
                    zipArchiveEntry2.setSize((long)byArray.length);
                    zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)zipArchiveEntry2);
                    zipArchiveOutputStream.write(byArray);
                    zipArchiveOutputStream.closeArchiveEntry();
                    continue;
                }
                zipArchiveOutputStream.addRawArchiveEntry(zipArchiveEntry2, zipFile.getRawInputStream(zipArchiveEntry));
            }
        }
    }

    private Stripper getSubFilter(String string) {
        for (Map.Entry<String, Stripper> entry : this.subFilters.entrySet()) {
            if (!string.matches(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private List<String> sortEntriesByName(Enumeration<ZipArchiveEntry> enumeration) {
        return Collections.list(enumeration).stream().map(zipArchiveEntry -> zipArchiveEntry.getName()).sorted(MANIFEST_FILE_SORT_COMPARATOR).collect(Collectors.toList());
    }

    private ZipArchiveEntry filterZipEntry(ZipArchiveEntry zipArchiveEntry) {
        zipArchiveEntry.setCreationTime(FileTime.fromMillis(this.zipTimestamp));
        zipArchiveEntry.setLastAccessTime(FileTime.fromMillis(this.zipTimestamp));
        zipArchiveEntry.setLastModifiedTime(FileTime.fromMillis(this.zipTimestamp));
        zipArchiveEntry.setTime(this.zipTimestamp);
        for (ZipExtraField zipExtraField : zipArchiveEntry.getExtraFields()) {
            if (!(zipExtraField instanceof X5455_ExtendedTimestamp)) continue;
            zipArchiveEntry.removeExtraField(zipExtraField.getHeaderId());
        }
        return zipArchiveEntry;
    }
}

