/*
 * Decompiled with CFR 0.152.
 */
package de.gccc.jib;

import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.frontend.BuildStepsExecutionException;
import com.google.cloud.tools.jib.frontend.BuildStepsRunner;
import com.google.cloud.tools.jib.frontend.HelpfulSuggestions;
import com.google.cloud.tools.jib.frontend.JavaEntrypointConstructor;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import de.gccc.jib.SbtConfiguration;
import de.gccc.jib.SbtConfiguration$;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;

public final class SbtDockerBuild$ {
    public static SbtDockerBuild$ MODULE$;
    private final String USER_AGENT_SUFFIX;

    static {
        new SbtDockerBuild$();
    }

    private String USER_AGENT_SUFFIX() {
        return this.USER_AGENT_SUFFIX;
    }

    public void task(SbtConfiguration configuration, Option<String> jibBaseImageCredentialHelper, String defaultImage, List<String> jvmFlags, List<String> args) {
        HelpfulSuggestions HELPFUL_SUGGESTIONS = SbtConfiguration$.MODULE$.helpfulSuggestionProvider("Build to Docker daemon failed");
        if (!new DockerClient().isDockerInstalled()) {
            throw new Exception(HELPFUL_SUGGESTIONS.forDockerNotInstalled());
        }
        ImageReference baseImageReference = ImageReference.parse(defaultImage);
        BuildLogger buildLogger = configuration.getLogger();
        BuildConfiguration buildConfiguration = BuildConfiguration.builder(buildLogger).setBaseImage(baseImageReference).setTargetImage(configuration.targetImageReference()).setBaseImageCredentialHelperName((String)jibBaseImageCredentialHelper.orNull(Predef$.MODULE$.$conforms())).setKnownBaseRegistryCredentials((RegistryCredentials)configuration.baseImageCredentials().orNull(Predef$.MODULE$.$conforms())).setJavaArguments((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(args).asJava()).setEntrypoint(JavaEntrypointConstructor.makeDefaultEntrypoint((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(jvmFlags).asJava(), configuration.getMainClassFromJar())).setLayerConfigurations((java.util.List<LayerConfiguration>)configuration.getLayerConfigurations()).build();
        RegistryClient.setUserAgentSuffix(this.USER_AGENT_SUFFIX());
        try {
            BuildStepsRunner.forBuildToDockerDaemon(buildConfiguration).build(HELPFUL_SUGGESTIONS);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof CacheDirectoryCreationException ? true : throwable2 instanceof BuildStepsExecutionException;
            if (bl) {
                throw new Exception(throwable2.getMessage(), throwable2.getCause());
            }
            throw throwable;
        }
    }

    private SbtDockerBuild$() {
        MODULE$ = this;
        this.USER_AGENT_SUFFIX = "jib-sbt-plugin";
    }
}

