/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.tar;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.Blobs;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class TarStreamBuilder {
    private final LinkedHashMap<TarArchiveEntry, Blob> archiveMap = new LinkedHashMap();

    private void writeEntriesAsTarArchive(OutputStream outputStream) throws IOException {
        try (TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream(outputStream, StandardCharsets.UTF_8.name());){
            tarArchiveOutputStream.setLongFileMode(3);
            for (Map.Entry<TarArchiveEntry, Blob> entry : this.archiveMap.entrySet()) {
                tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)entry.getKey());
                entry.getValue().writeTo((OutputStream)tarArchiveOutputStream);
                tarArchiveOutputStream.closeArchiveEntry();
            }
        }
    }

    public void addTarArchiveEntry(TarArchiveEntry tarArchiveEntry) {
        this.archiveMap.put(tarArchiveEntry, tarArchiveEntry.isFile() ? Blobs.from(tarArchiveEntry.getFile().toPath()) : Blobs.from(outputStream -> {}));
    }

    public void addByteEntry(byte[] byArray, String string) {
        TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(string);
        tarArchiveEntry.setSize((long)byArray.length);
        this.archiveMap.put(tarArchiveEntry, Blobs.from(outputStream -> outputStream.write(byArray)));
    }

    public Blob toBlob() {
        return Blobs.from(this::writeEntriesAsTarArchive);
    }
}

