/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry.credentials;

import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Authorizations;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryAliasGroup;
import com.google.cloud.tools.jib.registry.credentials.DockerConfig;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelper;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelperFactory;
import com.google.cloud.tools.jib.registry.credentials.NonexistentDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.NonexistentServerUrlDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.json.DockerConfigTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;

public class DockerConfigCredentialRetriever {
    private static final Path DOCKER_CONFIG_FILE = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".docker").resolve("config.json");
    private final String registry;
    private final Path dockerConfigFile;
    private final DockerCredentialHelperFactory dockerCredentialHelperFactory;

    public DockerConfigCredentialRetriever(String string) {
        this(string, DOCKER_CONFIG_FILE);
    }

    @VisibleForTesting
    DockerConfigCredentialRetriever(String string, Path path) {
        this.registry = string;
        this.dockerConfigFile = path;
        this.dockerCredentialHelperFactory = new DockerCredentialHelperFactory();
    }

    @VisibleForTesting
    DockerConfigCredentialRetriever(String string, Path path, DockerCredentialHelperFactory dockerCredentialHelperFactory) {
        this.registry = string;
        this.dockerConfigFile = path;
        this.dockerCredentialHelperFactory = dockerCredentialHelperFactory;
    }

    @Nullable
    public Authorization retrieve() throws IOException {
        DockerConfigTemplate dockerConfigTemplate = this.loadDockerConfigTemplate();
        if (dockerConfigTemplate == null) {
            return null;
        }
        DockerConfig dockerConfig = new DockerConfig(dockerConfigTemplate);
        for (String string : RegistryAliasGroup.getAliasesGroup(this.registry)) {
            Authorization authorization = this.retrieve(dockerConfig, string);
            if (authorization == null) continue;
            return authorization;
        }
        return null;
    }

    @Nullable
    private Authorization retrieve(DockerConfig dockerConfig, String string) {
        String string2 = dockerConfig.getAuthFor(string);
        if (string2 != null) {
            return Authorizations.withBasicToken(string2);
        }
        DockerCredentialHelper dockerCredentialHelper = dockerConfig.getCredentialHelperFor(this.dockerCredentialHelperFactory, string);
        if (dockerCredentialHelper != null) {
            try {
                return dockerCredentialHelper.retrieve();
            }
            catch (NonexistentDockerCredentialHelperException | NonexistentServerUrlDockerCredentialHelperException | IOException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private DockerConfigTemplate loadDockerConfigTemplate() throws IOException {
        if (!Files.exists(this.dockerConfigFile, new LinkOption[0])) {
            return null;
        }
        return JsonTemplateMapper.readJsonFromFile(this.dockerConfigFile, DockerConfigTemplate.class);
    }
}

