/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.api.client.http.GenericUrl;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import com.google.cloud.tools.jib.registry.RegistryErrorExceptionBuilder;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.net.MediaType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

class BlobPusher {
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final DescriptorDigest blobDigest;
    private final Blob blob;

    BlobPusher(RegistryEndpointRequestProperties registryEndpointRequestProperties, DescriptorDigest descriptorDigest, Blob blob) {
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.blobDigest = descriptorDigest;
        this.blob = blob;
    }

    RegistryEndpointProvider<URL> initializer() {
        return new Initializer();
    }

    RegistryEndpointProvider<URL> writer(URL uRL) {
        return new Writer(uRL);
    }

    RegistryEndpointProvider<Void> committer(URL uRL) {
        return new Committer(uRL);
    }

    private RegistryErrorException buildRegistryErrorException(String string) {
        RegistryErrorExceptionBuilder registryErrorExceptionBuilder = new RegistryErrorExceptionBuilder(this.getActionDescription());
        registryErrorExceptionBuilder.addReason(string);
        return registryErrorExceptionBuilder.build();
    }

    private String getActionDescription() {
        return "push BLOB for " + this.registryEndpointRequestProperties.getServerUrl() + "/" + this.registryEndpointRequestProperties.getImageName() + " with digest " + this.blobDigest;
    }

    private URL getRedirectLocation(Response response) throws RegistryErrorException {
        List<String> list = response.getHeader("Location");
        if (list.size() != 1) {
            throw this.buildRegistryErrorException("Expected 1 'Location' header, but found " + list.size());
        }
        String string = list.get(0);
        return response.getRequestUrl().toURL(string);
    }

    private class Committer
    implements RegistryEndpointProvider<Void> {
        private final URL location;

        @Override
        @Nullable
        public BlobHttpContent getContent() {
            return null;
        }

        @Override
        public List<String> getAccept() {
            return Collections.emptyList();
        }

        @Override
        public Void handleResponse(Response response) {
            return null;
        }

        @Override
        public URL getApiRoute(String string) {
            return new GenericUrl(this.location).set("digest", (Object)BlobPusher.this.blobDigest).toURL();
        }

        @Override
        public String getHttpMethod() {
            return "PUT";
        }

        @Override
        public String getActionDescription() {
            return BlobPusher.this.getActionDescription();
        }

        private Committer(URL uRL) {
            this.location = uRL;
        }
    }

    private class Writer
    implements RegistryEndpointProvider<URL> {
        private final URL location;

        @Override
        @Nullable
        public BlobHttpContent getContent() {
            return new BlobHttpContent(BlobPusher.this.blob, MediaType.OCTET_STREAM.toString());
        }

        @Override
        public List<String> getAccept() {
            return Collections.emptyList();
        }

        @Override
        public URL handleResponse(Response response) throws RegistryException {
            return BlobPusher.this.getRedirectLocation(response);
        }

        @Override
        public URL getApiRoute(String string) {
            return this.location;
        }

        @Override
        public String getHttpMethod() {
            return "PATCH";
        }

        @Override
        public String getActionDescription() {
            return BlobPusher.this.getActionDescription();
        }

        private Writer(URL uRL) {
            this.location = uRL;
        }
    }

    private class Initializer
    implements RegistryEndpointProvider<URL> {
        private Initializer() {
        }

        @Override
        @Nullable
        public BlobHttpContent getContent() {
            return null;
        }

        @Override
        public List<String> getAccept() {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public URL handleResponse(Response response) throws RegistryErrorException {
            switch (response.getStatusCode()) {
                case 201: {
                    return null;
                }
                case 202: {
                    return BlobPusher.this.getRedirectLocation(response);
                }
            }
            throw BlobPusher.this.buildRegistryErrorException("Received unrecognized status code " + response.getStatusCode());
        }

        @Override
        public URL getApiRoute(String string) throws MalformedURLException {
            return new URL(string + BlobPusher.this.registryEndpointRequestProperties.getImageName() + "/blobs/uploads/?mount=" + BlobPusher.this.blobDigest);
        }

        @Override
        public String getHttpMethod() {
            return "POST";
        }

        @Override
        public String getActionDescription() {
            return BlobPusher.this.getActionDescription();
        }
    }
}

