/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSortedMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ImageToJsonTranslator {
    private final Image<CachedLayer> image;

    @Nullable
    @VisibleForTesting
    static Map<String, Map<?, ?>> portListToMap(@Nullable List<Port> list) {
        if (list == null) {
            return null;
        }
        ImmutableSortedMap.Builder builder = new ImmutableSortedMap.Builder(String::compareTo);
        for (Port port : list) {
            builder.put((Object)(port.getPort() + "/" + (Object)((Object)port.getProtocol())), Collections.emptyMap());
        }
        return builder.build();
    }

    public ImageToJsonTranslator(Image<CachedLayer> image) {
        this.image = image;
    }

    public Blob getContainerConfigurationBlob() {
        ContainerConfigurationTemplate containerConfigurationTemplate = new ContainerConfigurationTemplate();
        for (CachedLayer cachedLayer : this.image.getLayers()) {
            containerConfigurationTemplate.addLayerDiffId(cachedLayer.getDiffId());
        }
        containerConfigurationTemplate.setCreated(this.image.getCreated() == null ? null : this.image.getCreated().toString());
        containerConfigurationTemplate.setContainerEnvironment((List<String>)this.image.getEnvironment());
        containerConfigurationTemplate.setContainerEntrypoint((List<String>)this.image.getEntrypoint());
        containerConfigurationTemplate.setContainerCmd((List<String>)this.image.getJavaArguments());
        containerConfigurationTemplate.setContainerExposedPorts(ImageToJsonTranslator.portListToMap(this.image.getExposedPorts()));
        return JsonTemplateMapper.toBlob(containerConfigurationTemplate);
    }

    public <T extends BuildableManifestTemplate> T getManifestTemplate(Class<T> clazz, BlobDescriptor blobDescriptor) {
        try {
            BuildableManifestTemplate buildableManifestTemplate = (BuildableManifestTemplate)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DescriptorDigest descriptorDigest = blobDescriptor.getDigest();
            long l = blobDescriptor.getSize();
            buildableManifestTemplate.setContainerConfiguration(l, descriptorDigest);
            for (CachedLayer cachedLayer : this.image.getLayers()) {
                buildableManifestTemplate.addLayer(cachedLayer.getBlobDescriptor().getSize(), cachedLayer.getBlobDescriptor().getDigest());
            }
            return (T)buildableManifestTemplate;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new IllegalArgumentException(clazz + " cannot be instantiated", reflectiveOperationException);
        }
    }
}

