/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import java.nio.file.Path;
import java.util.function.Function;

public class HelpfulSuggestions {
    private final String messagePrefix;
    private final String clearCacheCommand;
    private final String baseImageCredHelperConfiguration;
    private final Function<String, String> baseImageAuthConfiguration;
    private final String targetImageCredHelperConfiguration;
    private final Function<String, String> targetImageAuthConfiguration;

    public HelpfulSuggestions(String string, String string2, String string3, Function<String, String> function, String string4, Function<String, String> function2) {
        this.messagePrefix = string;
        this.clearCacheCommand = string2;
        this.baseImageCredHelperConfiguration = string3;
        this.baseImageAuthConfiguration = function;
        this.targetImageCredHelperConfiguration = string4;
        this.targetImageAuthConfiguration = function2;
    }

    public String forHttpHostConnect() {
        return this.suggest("make sure your Internet is up and that the registry you are pushing to exists");
    }

    public String forUnknownHost() {
        return this.suggest("make sure that the registry you configured exists/is spelled properly");
    }

    public String forCacheNeedsClean() {
        return this.suggest("run '" + this.clearCacheCommand + "' to clear your build cache");
    }

    public String forCacheDirectoryNotOwned(Path path) {
        return this.suggest("check that '" + path + "' is not used by another application or set the `useOnlyProjectCache` configuration");
    }

    public String forHttpStatusCodeForbidden(String string) {
        return this.suggest("make sure you have permissions for " + string);
    }

    public String forNoCredentialHelpersDefinedForBaseImage(String string) {
        return this.forNoCredentialHelpersDefined(this.baseImageCredHelperConfiguration, this.baseImageAuthConfiguration.apply(string));
    }

    public String forNoCredentialHelpersDefinedForTargetImage(String string) {
        return this.forNoCredentialHelpersDefined(this.targetImageCredHelperConfiguration, this.targetImageAuthConfiguration.apply(string));
    }

    public String forCredentialsNotCorrect(String string) {
        return this.suggest("make sure your credentials for '" + string + "' are set up correctly");
    }

    public String forCredentialsNotSent() {
        return this.suggest("use a registry that supports HTTPS so credentials can be sent safely, or set the 'sendCredentialsOverHttp' system property to true");
    }

    public String forDockerContextInsecureRecursiveDelete(String string) {
        return this.suggest("clear " + string + " manually before creating the Docker context");
    }

    public String forMainClassNotFound(String string) {
        return this.suggest("add a `mainClass` configuration to " + string);
    }

    public String forDockerNotInstalled() {
        return this.suggest("make sure Docker is installed and you have correct privileges to run it");
    }

    public String forInsecureRegistry() {
        return this.suggest("use a registry that supports HTTPS or set the configuration parameter 'allowInsecureRegistries'");
    }

    public String forToNotConfigured(String string, String string2, String string3) {
        return this.suggest("add a " + string + " configuration parameter to your " + string2 + " or set the parameter via the commandline (e.g. '" + string3 + "').");
    }

    public String none() {
        return this.messagePrefix;
    }

    public String suggest(String string) {
        return this.messagePrefix + ", perhaps you should " + string;
    }

    private String forNoCredentialHelpersDefined(String string, String string2) {
        return this.suggest("set a credential helper name with the configuration '" + string + "' or " + string2);
    }
}

