/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.builder.BuildSteps;
import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.cache.CacheDirectoryNotOwnedException;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.Caches;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.CacheConfiguration;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.frontend.BuildStepsExecutionException;
import com.google.cloud.tools.jib.frontend.HelpfulSuggestions;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.cloud.tools.jib.registry.InsecureRegistryException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryCredentialsNotSentException;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import com.google.cloud.tools.jib.registry.RegistryUnauthorizedException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import org.apache.http.conn.HttpHostConnectException;

public class BuildStepsRunner {
    private final BuildSteps buildSteps;

    public static BuildStepsRunner forBuildImage(BuildConfiguration buildConfiguration) throws CacheDirectoryCreationException {
        return new BuildStepsRunner(BuildSteps.forBuildToDockerRegistry(buildConfiguration, BuildStepsRunner.getCacheInitializer(buildConfiguration)));
    }

    public static BuildStepsRunner forBuildToDockerDaemon(BuildConfiguration buildConfiguration) throws CacheDirectoryCreationException {
        return new BuildStepsRunner(BuildSteps.forBuildToDockerDaemon(buildConfiguration, BuildStepsRunner.getCacheInitializer(buildConfiguration)));
    }

    public static BuildStepsRunner forBuildTar(Path path, BuildConfiguration buildConfiguration) throws CacheDirectoryCreationException {
        return new BuildStepsRunner(BuildSteps.forBuildToTar(path, buildConfiguration, BuildStepsRunner.getCacheInitializer(buildConfiguration)));
    }

    private static Caches.Initializer getCacheInitializer(BuildConfiguration buildConfiguration) throws CacheDirectoryCreationException {
        CacheConfiguration cacheConfiguration = buildConfiguration.getApplicationLayersCacheConfiguration() == null ? CacheConfiguration.makeTemporary() : buildConfiguration.getApplicationLayersCacheConfiguration();
        CacheConfiguration cacheConfiguration2 = buildConfiguration.getBaseImageLayersCacheConfiguration() == null ? CacheConfiguration.forDefaultUserLevelCacheDirectory() : buildConfiguration.getBaseImageLayersCacheConfiguration();
        return new Caches.Initializer(cacheConfiguration2.getCacheDirectory(), cacheConfiguration.shouldEnsureOwnership(), cacheConfiguration.getCacheDirectory(), cacheConfiguration.shouldEnsureOwnership());
    }

    private static void handleRegistryUnauthorizedException(RegistryUnauthorizedException registryUnauthorizedException, BuildConfiguration buildConfiguration, HelpfulSuggestions helpfulSuggestions) throws BuildStepsExecutionException {
        boolean bl;
        if (registryUnauthorizedException.getHttpResponseException().getStatusCode() == 403) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forHttpStatusCodeForbidden(registryUnauthorizedException.getImageReference()), registryUnauthorizedException);
        }
        boolean bl2 = registryUnauthorizedException.getRegistry().equals(buildConfiguration.getBaseImageRegistry());
        boolean bl3 = registryUnauthorizedException.getRegistry().equals(buildConfiguration.getTargetImageRegistry());
        boolean bl4 = buildConfiguration.getBaseImageCredentialHelperName() != null || buildConfiguration.getKnownBaseRegistryCredentials() != null;
        boolean bl5 = bl = buildConfiguration.getTargetImageCredentialHelperName() != null || buildConfiguration.getKnownTargetRegistryCredentials() != null;
        if (bl2 && !bl4) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forNoCredentialHelpersDefinedForBaseImage(registryUnauthorizedException.getRegistry()), registryUnauthorizedException);
        }
        if (bl3 && !bl) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forNoCredentialHelpersDefinedForTargetImage(registryUnauthorizedException.getRegistry()), registryUnauthorizedException);
        }
        throw new BuildStepsExecutionException(helpfulSuggestions.forCredentialsNotCorrect(registryUnauthorizedException.getRegistry()), registryUnauthorizedException);
    }

    private static String capitalizeFirstLetter(String string) {
        if (string.length() == 0) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    @VisibleForTesting
    BuildStepsRunner(BuildSteps buildSteps) {
        this.buildSteps = buildSteps;
    }

    public void build(HelpfulSuggestions helpfulSuggestions) throws BuildStepsExecutionException {
        try {
            BuildLogger buildLogger = this.buildSteps.getBuildConfiguration().getBuildLogger();
            buildLogger.lifecycle("");
            buildLogger.lifecycle(this.buildSteps.getStartupMessage());
            buildLogger.info("Containerizing application with the following files:");
            for (LayerConfiguration layerConfiguration : this.buildSteps.getBuildConfiguration().getLayerConfigurations()) {
                buildLogger.info("\t" + BuildStepsRunner.capitalizeFirstLetter(layerConfiguration.getLabel()) + ":");
                for (LayerEntry layerEntry : layerConfiguration.getLayerEntries()) {
                    for (Path path : layerEntry.getSourceFiles()) {
                        buildLogger.info("\t\t" + path);
                    }
                }
            }
            this.buildSteps.run();
            buildLogger.lifecycle("");
            buildLogger.lifecycle(this.buildSteps.getSuccessMessage());
        }
        catch (CacheMetadataCorruptedException cacheMetadataCorruptedException) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forCacheNeedsClean(), cacheMetadataCorruptedException);
        }
        catch (ExecutionException executionException) {
            BuildConfiguration buildConfiguration = this.buildSteps.getBuildConfiguration();
            Throwable throwable = executionException.getCause();
            if (throwable instanceof HttpHostConnectException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forHttpHostConnect(), throwable);
            }
            if (throwable instanceof RegistryUnauthorizedException) {
                BuildStepsRunner.handleRegistryUnauthorizedException((RegistryUnauthorizedException)throwable, buildConfiguration, helpfulSuggestions);
            }
            if (throwable instanceof RegistryCredentialsNotSentException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forCredentialsNotSent(), throwable);
            }
            if (throwable instanceof RegistryAuthenticationFailedException && throwable.getCause() instanceof HttpResponseException) {
                BuildStepsRunner.handleRegistryUnauthorizedException(new RegistryUnauthorizedException(buildConfiguration.getTargetImageRegistry(), buildConfiguration.getTargetImageRepository(), (HttpResponseException)throwable.getCause()), buildConfiguration, helpfulSuggestions);
            }
            if (throwable instanceof UnknownHostException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forUnknownHost(), throwable);
            }
            if (throwable instanceof InsecureRegistryException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forInsecureRegistry(), throwable);
            }
            if (throwable instanceof RegistryErrorException) {
                RegistryErrorException registryErrorException = (RegistryErrorException)throwable;
                String string = (String)Verify.verifyNotNull((Object)registryErrorException.getMessage());
                throw new BuildStepsExecutionException(string, throwable);
            }
            throw new BuildStepsExecutionException(helpfulSuggestions.none(), executionException.getCause());
        }
        catch (CacheDirectoryCreationException | IOException | InterruptedException exception) {
            throw new BuildStepsExecutionException(helpfulSuggestions.none(), exception);
        }
        catch (CacheDirectoryNotOwnedException cacheDirectoryNotOwnedException) {
            String string = helpfulSuggestions.forCacheDirectoryNotOwned(cacheDirectoryNotOwnedException.getCacheDirectory());
            CacheConfiguration cacheConfiguration = this.buildSteps.getBuildConfiguration().getApplicationLayersCacheConfiguration();
            if (cacheConfiguration != null && cacheDirectoryNotOwnedException.getCacheDirectory().equals(cacheConfiguration.getCacheDirectory())) {
                string = helpfulSuggestions.forCacheNeedsClean();
            }
            throw new BuildStepsExecutionException(string, cacheDirectoryNotOwnedException);
        }
    }
}

