/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheMetadata;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.ImageLayers;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import javax.annotation.Nullable;

public class CacheReader {
    private final Cache cache;

    private static FileTime getLastModifiedTime(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            ImmutableList<Path> immutableList = new DirectoryWalker(path).walk();
            FileTime fileTime = FileTime.from(Instant.MIN);
            for (Path path2 : immutableList) {
                FileTime fileTime2 = Files.getLastModifiedTime(path2, new LinkOption[0]);
                if (fileTime2.compareTo(fileTime) <= 0) continue;
                fileTime = fileTime2;
            }
            return fileTime;
        }
        return Files.getLastModifiedTime(path, new LinkOption[0]);
    }

    public CacheReader(Cache cache) {
        this.cache = cache;
    }

    @Nullable
    public CachedLayer getLayer(DescriptorDigest descriptorDigest) {
        return this.cache.getMetadata().getLayers().get(descriptorDigest);
    }

    @Nullable
    public Path getLayerFile(ImmutableList<LayerEntry> immutableList) throws CacheMetadataCorruptedException {
        CacheMetadata cacheMetadata = this.cache.getMetadata();
        ImageLayers<CachedLayerWithMetadata> imageLayers = cacheMetadata.filterLayers().byLayerEntries(immutableList).filter();
        FileTime fileTime = FileTime.from(Instant.MIN);
        Path path = null;
        for (CachedLayerWithMetadata cachedLayerWithMetadata : imageLayers) {
            if (cachedLayerWithMetadata.getMetadata() == null) {
                throw new IllegalStateException("Layers with sourceFiles should have metadata");
            }
            FileTime fileTime2 = cachedLayerWithMetadata.getMetadata().getLastModifiedTime();
            if (fileTime2.compareTo(fileTime) <= 0) continue;
            fileTime = fileTime2;
            path = cachedLayerWithMetadata.getContentFile();
        }
        return path;
    }

    @Nullable
    public CachedLayerWithMetadata getUpToDateLayerByLayerEntries(ImmutableList<LayerEntry> immutableList) throws IOException, CacheMetadataCorruptedException {
        ImageLayers<CachedLayerWithMetadata> imageLayers = this.cache.getMetadata().filterLayers().byLayerEntries(immutableList).filter();
        if (imageLayers.isEmpty()) {
            return null;
        }
        FileTime fileTime = FileTime.from(Instant.MIN);
        for (Object object : immutableList) {
            for (Path path : ((LayerEntry)object).getSourceFiles()) {
                FileTime fileTime2 = CacheReader.getLastModifiedTime(path);
                if (fileTime2.compareTo(fileTime) <= 0) continue;
                fileTime = fileTime2;
            }
        }
        for (Object object : imageLayers) {
            if (((CachedLayerWithMetadata)object).getMetadata() == null) {
                throw new IllegalStateException("Layers with sourceFiles should have metadata");
            }
            if (fileTime.compareTo(((CachedLayerWithMetadata)object).getMetadata().getLastModifiedTime()) > 0) continue;
            return object;
        }
        return null;
    }
}

