/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.builder.steps.BuildAndCacheApplicationLayerStep;
import com.google.cloud.tools.jib.builder.steps.BuildImageStep;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayerStep;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayersStep;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.docker.ImageToTarballTranslator;
import com.google.cloud.tools.jib.image.Image;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class LoadDockerStep
implements AsyncStep<Void>,
Callable<Void> {
    private final BuildConfiguration buildConfiguration;
    private final PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep;
    private final ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps;
    private final BuildImageStep buildImageStep;
    private final ListeningExecutorService listeningExecutorService;
    private final ListenableFuture<Void> listenableFuture;

    LoadDockerStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep, ImmutableList<BuildAndCacheApplicationLayerStep> immutableList, BuildImageStep buildImageStep) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
        this.pullAndCacheBaseImageLayersStep = pullAndCacheBaseImageLayersStep;
        this.buildAndCacheApplicationLayerSteps = immutableList;
        this.buildImageStep = buildImageStep;
        this.listenableFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{pullAndCacheBaseImageLayersStep.getFuture(), buildImageStep.getFuture()}).call((Callable)this, (Executor)listeningExecutorService);
    }

    @Override
    public ListenableFuture<Void> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public Void call() throws ExecutionException, InterruptedException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AsyncStep<CachedLayer> asyncStep : NonBlockingSteps.get(this.pullAndCacheBaseImageLayersStep)) {
            builder.add(((PullAndCacheBaseImageLayerStep)asyncStep).getFuture());
        }
        for (AsyncStep<CachedLayer> asyncStep : this.buildAndCacheApplicationLayerSteps) {
            builder.add(((BuildAndCacheApplicationLayerStep)asyncStep).getFuture());
        }
        builder.add(NonBlockingSteps.get(this.buildImageStep).getFuture());
        return (Void)Futures.whenAllSucceed((Iterable)builder.build()).call(this::afterPushBaseImageLayerFuturesFuture, (Executor)this.listeningExecutorService).get();
    }

    private Void afterPushBaseImageLayerFuturesFuture() throws ExecutionException, InterruptedException, IOException {
        Image<CachedLayer> image = NonBlockingSteps.get(NonBlockingSteps.get(this.buildImageStep));
        this.buildConfiguration.getBuildLogger().lifecycle("Loading to Docker daemon...");
        new DockerClient().load(new ImageToTarballTranslator(image).toTarballBlob(this.buildConfiguration.getTargetImageReference()));
        return null;
    }
}

