/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.builder.steps.BuildAndCacheApplicationLayerStep;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayerStep;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayersStep;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class BuildImageStep
implements AsyncStep<AsyncStep<Image<CachedLayer>>>,
Callable<AsyncStep<Image<CachedLayer>>> {
    private static final String DESCRIPTION = "Building container configuration";
    private final BuildConfiguration buildConfiguration;
    private final PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep;
    private final ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps;
    private final ListeningExecutorService listeningExecutorService;
    private final ListenableFuture<AsyncStep<Image<CachedLayer>>> listenableFuture;

    BuildImageStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep, ImmutableList<BuildAndCacheApplicationLayerStep> immutableList) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
        this.pullAndCacheBaseImageLayersStep = pullAndCacheBaseImageLayersStep;
        this.buildAndCacheApplicationLayerSteps = immutableList;
        this.listenableFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{pullAndCacheBaseImageLayersStep.getFuture()}).call((Callable)this, (Executor)listeningExecutorService);
    }

    @Override
    public ListenableFuture<AsyncStep<Image<CachedLayer>>> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public AsyncStep<Image<CachedLayer>> call() throws ExecutionException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (AsyncStep<CachedLayer> asyncStep : NonBlockingSteps.get(this.pullAndCacheBaseImageLayersStep)) {
            arrayList.add(((PullAndCacheBaseImageLayerStep)asyncStep).getFuture());
        }
        for (AsyncStep<CachedLayer> asyncStep : this.buildAndCacheApplicationLayerSteps) {
            arrayList.add(((BuildAndCacheApplicationLayerStep)asyncStep).getFuture());
        }
        UnmodifiableIterator unmodifiableIterator = Futures.whenAllSucceed(arrayList).call(this::afterCachedLayersSteps, (Executor)this.listeningExecutorService);
        return () -> BuildImageStep.lambda$call$0((ListenableFuture)unmodifiableIterator);
    }

    private Image<CachedLayer> afterCachedLayersSteps() throws ExecutionException, LayerPropertyNotFoundException {
        try (Timer timer = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION);){
            Image.Builder<Layer> builder = Image.builder();
            for (AsyncStep<CachedLayer> asyncStep : NonBlockingSteps.get(this.pullAndCacheBaseImageLayersStep)) {
                builder.addLayer(NonBlockingSteps.get(asyncStep));
            }
            for (AsyncStep<CachedLayer> asyncStep : this.buildAndCacheApplicationLayerSteps) {
                builder.addLayer(NonBlockingSteps.get(asyncStep));
            }
            builder.setCreated(this.buildConfiguration.getCreationTime());
            builder.setEnvironment((Map<String, String>)this.buildConfiguration.getEnvironment());
            builder.setEntrypoint((List<String>)this.buildConfiguration.getEntrypoint());
            builder.setJavaArguments((List<String>)this.buildConfiguration.getJavaArguments());
            builder.setExposedPorts(this.buildConfiguration.getExposedPorts());
            Object object = builder.build();
            return object;
        }
    }

    private static /* synthetic */ ListenableFuture lambda$call$0(ListenableFuture listenableFuture) {
        return listenableFuture;
    }
}

